/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.netconf.sal.rest.api.RestconfNormalizedNodeWriter;
import org.opendaylight.netconf.sal.rest.impl.DepthAwareNormalizedNodeWriter;
import org.opendaylight.netconf.sal.rest.impl.RestconfDelegatingNormalizedNodeWriter;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Deprecated
@Provider
@Produces(value={"application/yang.api+xml", "application/yang.data+xml", "application/yang.operation+xml", "application/xml", "text/xml"})
public class NormalizedNodeXmlBodyWriter
implements MessageBodyWriter<NormalizedNodeContext> {
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newFactory();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(NormalizedNodeContext.class);
    }

    public long getSize(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        XMLStreamWriter xmlWriter;
        for (Map.Entry entry : context.getNewHeaders().entrySet()) {
            httpHeaders.add(entry.getKey(), entry.getValue());
        }
        InstanceIdentifierContext pathContext = context.getInstanceIdentifierContext();
        if (context.getData() == null) {
            return;
        }
        try {
            xmlWriter = XML_FACTORY.createXMLStreamWriter(entityStream, StandardCharsets.UTF_8.name());
            if (context.getWriterParameters().isPrettyPrint()) {
                xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            }
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        NormalizedNode data = context.getData();
        SchemaPath schemaPath = pathContext.getSchemaNode().getPath();
        NormalizedNodeXmlBodyWriter.writeNormalizedNode(xmlWriter, schemaPath, pathContext, data, (Optional<Integer>)Optional.fromNullable((Object)context.getWriterParameters().getDepth()));
    }

    private static void writeNormalizedNode(XMLStreamWriter xmlWriter, SchemaPath schemaPath, InstanceIdentifierContext<?> pathContext, NormalizedNode<?, ?> data, Optional<Integer> depth) throws IOException {
        RestconfNormalizedNodeWriter nnWriter;
        SchemaContext schemaCtx = pathContext.getSchemaContext();
        if (SchemaPath.ROOT.equals((Object)schemaPath)) {
            nnWriter = NormalizedNodeXmlBodyWriter.createNormalizedNodeWriter(xmlWriter, schemaCtx, schemaPath, depth);
            NormalizedNodeXmlBodyWriter.writeElements(xmlWriter, nnWriter, (ContainerNode)data);
        } else if (pathContext.getSchemaNode() instanceof RpcDefinition) {
            nnWriter = NormalizedNodeXmlBodyWriter.createNormalizedNodeWriter(xmlWriter, schemaCtx, ((RpcDefinition)pathContext.getSchemaNode()).getOutput().getPath(), depth);
            NormalizedNodeXmlBodyWriter.writeElements(xmlWriter, nnWriter, (ContainerNode)data);
        } else {
            nnWriter = NormalizedNodeXmlBodyWriter.createNormalizedNodeWriter(xmlWriter, schemaCtx, schemaPath.getParent(), depth);
            if (data instanceof MapEntryNode) {
                data = ImmutableNodes.mapNodeBuilder((QName)data.getNodeType()).addChild((NormalizedNode)((MapEntryNode)data)).build();
            }
            nnWriter.write(data);
        }
        nnWriter.flush();
    }

    private static RestconfNormalizedNodeWriter createNormalizedNodeWriter(XMLStreamWriter xmlWriter, SchemaContext schemaContext, SchemaPath schemaPath, Optional<Integer> depth) {
        NormalizedNodeStreamWriter xmlStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)schemaContext, (SchemaPath)schemaPath);
        if (depth.isPresent()) {
            return DepthAwareNormalizedNodeWriter.forStreamWriter(xmlStreamWriter, (Integer)depth.get());
        }
        return RestconfDelegatingNormalizedNodeWriter.forStreamWriter(xmlStreamWriter);
    }

    private static void writeElements(XMLStreamWriter xmlWriter, RestconfNormalizedNodeWriter nnWriter, ContainerNode data) throws IOException {
        QName name = data.getNodeType();
        try {
            xmlWriter.writeStartElement("", name.getLocalName(), name.getNamespace().toString());
            xmlWriter.writeDefaultNamespace(name.getNamespace().toString());
            for (NormalizedNode child : data.getValue()) {
                nnWriter.write(child);
            }
            nnWriter.flush();
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to write elements", e);
        }
    }

    static {
        XML_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

