/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.patch.PatchStatusEntity;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;

@Provider
@Produces(value={"application/yang.patch-status+json"})
public class PatchJsonBodyWriter
implements MessageBodyWriter<PatchStatusContext> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(PatchStatusContext.class);
    }

    public long getSize(PatchStatusContext patchStatusContext, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PatchStatusContext patchStatusContext, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonWriter jsonWriter = PatchJsonBodyWriter.createJsonWriter(entityStream);
        jsonWriter.beginObject().name("ietf-yang-patch:yang-patch-status");
        jsonWriter.beginObject();
        jsonWriter.name("patch-id").value(patchStatusContext.getPatchId());
        if (patchStatusContext.isOk()) {
            PatchJsonBodyWriter.reportSuccess(jsonWriter);
        } else {
            if (patchStatusContext.getGlobalErrors() != null) {
                PatchJsonBodyWriter.reportErrors(patchStatusContext.getGlobalErrors(), jsonWriter);
            }
            jsonWriter.name("edit-status");
            jsonWriter.beginObject();
            jsonWriter.name("edit");
            jsonWriter.beginArray();
            for (PatchStatusEntity patchStatusEntity : patchStatusContext.getEditCollection()) {
                jsonWriter.beginObject();
                jsonWriter.name("edit-id").value(patchStatusEntity.getEditId());
                if (patchStatusEntity.getEditErrors() != null) {
                    PatchJsonBodyWriter.reportErrors(patchStatusEntity.getEditErrors(), jsonWriter);
                } else if (patchStatusEntity.isOk()) {
                    PatchJsonBodyWriter.reportSuccess(jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
        jsonWriter.flush();
    }

    private static void reportSuccess(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("ok").beginArray().nullValue().endArray();
    }

    private static void reportErrors(List<RestconfError> errors, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("errors");
        jsonWriter.beginObject();
        jsonWriter.name("error");
        jsonWriter.beginArray();
        for (RestconfError restconfError : errors) {
            jsonWriter.beginObject();
            jsonWriter.name("error-type").value(restconfError.getErrorType().getErrorTypeTag());
            jsonWriter.name("error-tag").value(restconfError.getErrorTag().getTagValue());
            if (restconfError.getErrorPath() != null) {
                jsonWriter.name("error-path").value(restconfError.getErrorPath().toString());
            }
            if (restconfError.getErrorMessage() != null) {
                jsonWriter.name("error-message").value(restconfError.getErrorMessage());
            }
            if (restconfError.getErrorInfo() != null) {
                jsonWriter.name("error-info").value(restconfError.getErrorInfo());
            }
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static JsonWriter createJsonWriter(OutputStream entityStream) {
        return JsonWriterFactory.createJsonWriter((Writer)new OutputStreamWriter(entityStream, StandardCharsets.UTF_8));
    }
}

