/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.patch.PatchStatusEntity;

@Provider
@Produces(value={"application/yang.patch-status+xml"})
public class PatchXmlBodyWriter
implements MessageBodyWriter<PatchStatusContext> {
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newFactory();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(PatchStatusContext.class);
    }

    public long getSize(PatchStatusContext patchStatusContext, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PatchStatusContext patchStatusContext, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        try {
            XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(entityStream, StandardCharsets.UTF_8.name());
            PatchXmlBodyWriter.writeDocument(xmlWriter, patchStatusContext);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeDocument(XMLStreamWriter writer, PatchStatusContext context) throws XMLStreamException {
        writer.writeStartElement("", "yang-patch-status", "urn:ietf:params:xml:ns:yang:ietf-yang-patch");
        writer.writeStartElement("patch-id");
        writer.writeCharacters(context.getPatchId());
        writer.writeEndElement();
        if (context.isOk()) {
            writer.writeEmptyElement("ok");
        } else {
            if (context.getGlobalErrors() != null) {
                PatchXmlBodyWriter.reportErrors(context.getGlobalErrors(), writer);
            }
            writer.writeStartElement("edit-status");
            for (PatchStatusEntity patchStatusEntity : context.getEditCollection()) {
                writer.writeStartElement("edit");
                writer.writeStartElement("edit-id");
                writer.writeCharacters(patchStatusEntity.getEditId());
                writer.writeEndElement();
                if (patchStatusEntity.getEditErrors() != null) {
                    PatchXmlBodyWriter.reportErrors(patchStatusEntity.getEditErrors(), writer);
                } else if (patchStatusEntity.isOk()) {
                    writer.writeEmptyElement("ok");
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.flush();
    }

    private static void reportErrors(List<RestconfError> errors, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("errors");
        for (RestconfError restconfError : errors) {
            writer.writeStartElement("error-type");
            writer.writeCharacters(restconfError.getErrorType().getErrorTypeTag());
            writer.writeEndElement();
            writer.writeStartElement("error-tag");
            writer.writeCharacters(restconfError.getErrorTag().getTagValue());
            writer.writeEndElement();
            if (restconfError.getErrorPath() != null) {
                writer.writeStartElement("error-path");
                writer.writeCharacters(restconfError.getErrorPath().toString());
                writer.writeEndElement();
            }
            if (restconfError.getErrorMessage() != null) {
                writer.writeStartElement("error-message");
                writer.writeCharacters(restconfError.getErrorMessage());
                writer.writeEndElement();
            }
            if (restconfError.getErrorInfo() == null) continue;
            writer.writeStartElement("error-info");
            writer.writeCharacters(restconfError.getErrorInfo());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    static {
        XML_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

