/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.base.Preconditions;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.netconf.md.sal.rest.schema.SchemaRetrievalService;
import org.opendaylight.netconf.sal.rest.api.RestconfService;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.schema.SchemaExportContext;

public class RestconfCompositeWrapper
implements RestconfService,
SchemaRetrievalService {
    private final RestconfService restconf;
    private final SchemaRetrievalService schema;

    public RestconfCompositeWrapper(RestconfService restconf, SchemaRetrievalService schema) {
        this.restconf = (RestconfService)Preconditions.checkNotNull((Object)restconf);
        this.schema = (SchemaRetrievalService)Preconditions.checkNotNull((Object)schema);
    }

    @Override
    public Object getRoot() {
        return this.restconf.getRoot();
    }

    @Override
    public NormalizedNodeContext getModules(UriInfo uriInfo) {
        return this.restconf.getModules(uriInfo);
    }

    @Override
    public NormalizedNodeContext getModules(String identifier, UriInfo uriInfo) {
        return this.restconf.getModules(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getModule(String identifier, UriInfo uriInfo) {
        return this.restconf.getModule(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getOperations(UriInfo uriInfo) {
        return this.restconf.getOperations(uriInfo);
    }

    @Override
    public NormalizedNodeContext getOperations(String identifier, UriInfo uriInfo) {
        return this.restconf.getOperations(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext invokeRpc(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.restconf.invokeRpc(identifier, payload, uriInfo);
    }

    @Override
    @Deprecated
    public NormalizedNodeContext invokeRpc(String identifier, String noPayload, UriInfo uriInfo) {
        return this.restconf.invokeRpc(identifier, noPayload, uriInfo);
    }

    @Override
    public NormalizedNodeContext readConfigurationData(String identifier, UriInfo uriInfo) {
        return this.restconf.readConfigurationData(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext readOperationalData(String identifier, UriInfo uriInfo) {
        return this.restconf.readOperationalData(identifier, uriInfo);
    }

    @Override
    public Response updateConfigurationData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.restconf.updateConfigurationData(identifier, payload, uriInfo);
    }

    @Override
    public Response createConfigurationData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.restconf.createConfigurationData(identifier, payload, uriInfo);
    }

    @Override
    public Response createConfigurationData(NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.restconf.createConfigurationData(payload, uriInfo);
    }

    @Override
    public Response deleteConfigurationData(String identifier) {
        return this.restconf.deleteConfigurationData(identifier);
    }

    @Override
    public NormalizedNodeContext subscribeToStream(String identifier, UriInfo uriInfo) {
        return this.restconf.subscribeToStream(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getAvailableStreams(UriInfo uriInfo) {
        return this.restconf.getAvailableStreams(uriInfo);
    }

    @Override
    public PatchStatusContext patchConfigurationData(String identifier, PatchContext payload, UriInfo uriInfo) {
        return this.restconf.patchConfigurationData(identifier, payload, uriInfo);
    }

    @Override
    public PatchStatusContext patchConfigurationData(PatchContext context, UriInfo uriInfo) {
        return this.restconf.patchConfigurationData(context, uriInfo);
    }

    @Override
    public SchemaExportContext getSchema(String mountId) {
        return this.schema.getSchema(mountId);
    }
}

