/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.netconf.sal.rest.api.Draft02;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestconfDocumentedExceptionMapper
implements ExceptionMapper<RestconfDocumentedException> {
    private static final Logger LOG = LoggerFactory.getLogger(RestconfDocumentedExceptionMapper.class);
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newFactory();
    @Context
    private HttpHeaders headers;
    private final ControllerContext controllerContext;

    public RestconfDocumentedExceptionMapper(ControllerContext controllerContext) {
        this.controllerContext = (ControllerContext)Preconditions.checkNotNull((Object)controllerContext);
    }

    public Response toResponse(RestconfDocumentedException exception) {
        LOG.debug("In toResponse: {}", (Object)exception.getMessage());
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        if (this.headers.getMediaType() != null) {
            mediaTypeList.add(this.headers.getMediaType());
        }
        mediaTypeList.addAll(this.headers.getAcceptableMediaTypes());
        MediaType mediaType = mediaTypeList.stream().filter(type -> !type.equals((Object)MediaType.WILDCARD_TYPE)).findFirst().orElse(MediaType.APPLICATION_JSON_TYPE);
        LOG.debug("Using MediaType: {}", (Object)mediaType);
        List errors = exception.getErrors();
        if (errors.isEmpty()) {
            return Response.status((Response.Status)exception.getStatus()).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)" ").build();
        }
        int status = ((RestconfError)errors.iterator().next()).getErrorTag().getStatusCode();
        DataNodeContainer errorsSchemaNode = (DataNodeContainer)this.controllerContext.getRestconfModuleErrorsSchemaNode();
        if (errorsSchemaNode == null) {
            return Response.status((int)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)exception.getMessage()).build();
        }
        Preconditions.checkState((boolean)(errorsSchemaNode instanceof ContainerSchemaNode), (Object)"Found Errors SchemaNode isn't ContainerNode");
        DataContainerNodeAttrBuilder errContBuild = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)errorsSchemaNode));
        List<DataSchemaNode> schemaList = ControllerContext.findInstanceDataChildrenByName(errorsSchemaNode, "error");
        DataSchemaNode errListSchemaNode = (DataSchemaNode)Iterables.getFirst(schemaList, null);
        Preconditions.checkState((boolean)(errListSchemaNode instanceof ListSchemaNode), (Object)"Found Error SchemaNode isn't ListSchemaNode");
        CollectionNodeBuilder listErorsBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)errListSchemaNode));
        for (RestconfError error : errors) {
            listErorsBuilder.withChild((NormalizedNode)RestconfDocumentedExceptionMapper.toErrorEntryNode(error, errListSchemaNode));
        }
        errContBuild.withChild((DataContainerChild)listErorsBuilder.build());
        NormalizedNodeContext errContext = new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)((DataSchemaNode)errorsSchemaNode), null, this.controllerContext.getGlobalSchema()), errContBuild.build());
        Object responseBody = mediaType.getSubtype().endsWith("json") ? RestconfDocumentedExceptionMapper.toJsonResponseBody(errContext, errorsSchemaNode) : RestconfDocumentedExceptionMapper.toXMLResponseBody(errContext, errorsSchemaNode);
        return Response.status((int)status).type(mediaType).entity(responseBody).build();
    }

    private static MapEntryNode toErrorEntryNode(RestconfError error, DataSchemaNode errListSchemaNode) {
        Preconditions.checkArgument((boolean)(errListSchemaNode instanceof ListSchemaNode), (Object)"errListSchemaNode has to be of type ListSchemaNode");
        ListSchemaNode listStreamSchemaNode = (ListSchemaNode)errListSchemaNode;
        DataContainerNodeAttrBuilder errNodeValues = Builders.mapEntryBuilder((ListSchemaNode)listStreamSchemaNode);
        List<DataSchemaNode> lsChildDataSchemaNode = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "error-type");
        DataSchemaNode errTypSchemaNode = (DataSchemaNode)Iterables.getFirst(lsChildDataSchemaNode, null);
        Preconditions.checkState((boolean)(errTypSchemaNode instanceof LeafSchemaNode));
        errNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)errTypSchemaNode)).withValue((Object)error.getErrorType().getErrorTypeTag()).build());
        lsChildDataSchemaNode = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "error-tag");
        DataSchemaNode errTagSchemaNode = (DataSchemaNode)Iterables.getFirst(lsChildDataSchemaNode, null);
        Preconditions.checkState((boolean)(errTagSchemaNode instanceof LeafSchemaNode));
        errNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)errTagSchemaNode)).withValue((Object)error.getErrorTag().getTagValue()).build());
        if (error.getErrorAppTag() != null) {
            lsChildDataSchemaNode = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "error-app-tag");
            DataSchemaNode errAppTagSchemaNode = (DataSchemaNode)Iterables.getFirst(lsChildDataSchemaNode, null);
            Preconditions.checkState((boolean)(errAppTagSchemaNode instanceof LeafSchemaNode));
            errNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)errAppTagSchemaNode)).withValue((Object)error.getErrorAppTag()).build());
        }
        lsChildDataSchemaNode = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "error-message");
        DataSchemaNode errMsgSchemaNode = (DataSchemaNode)Iterables.getFirst(lsChildDataSchemaNode, null);
        Preconditions.checkState((boolean)(errMsgSchemaNode instanceof LeafSchemaNode));
        errNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)errMsgSchemaNode)).withValue((Object)error.getErrorMessage()).build());
        if (error.getErrorInfo() != null) {
            errNodeValues.withChild((DataContainerChild)ImmutableNodes.leafNode((QName)Draft02.RestConfModule.ERROR_INFO_QNAME, (Object)error.getErrorInfo()));
        }
        return (MapEntryNode)errNodeValues.build();
    }

    private static Object toJsonResponseBody(NormalizedNodeContext errorsNode, DataNodeContainer errorsSchemaNode) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        NormalizedNode data = errorsNode.getData();
        InstanceIdentifierContext context = errorsNode.getInstanceIdentifierContext();
        DataSchemaNode schema = (DataSchemaNode)context.getSchemaNode();
        SchemaPath path = context.getSchemaNode().getPath();
        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8);
        if (data == null) {
            throw new RestconfDocumentedException(Response.Status.NOT_FOUND);
        }
        boolean isDataRoot = false;
        URI initialNs = null;
        if (SchemaPath.ROOT.equals((Object)path)) {
            isDataRoot = true;
        } else {
            path = path.getParent();
        }
        if (!schema.isAugmenting() && !(schema instanceof SchemaContext)) {
            initialNs = schema.getQName().getNamespace();
        }
        final JsonWriter jsonWriter = JsonWriterFactory.createJsonWriter((Writer)outputWriter);
        final NormalizedNodeStreamWriter jsonStreamWriter = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(context.getSchemaContext()), (SchemaPath)path, (URI)initialNs, (JsonWriter)jsonWriter);
        ForwardingNormalizedNodeStreamWriter streamWriter = new ForwardingNormalizedNodeStreamWriter(){

            protected NormalizedNodeStreamWriter delegate() {
                return jsonStreamWriter;
            }

            public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
                if (name.getNodeType().equals((Object)Draft02.RestConfModule.ERROR_INFO_QNAME)) {
                    jsonWriter.name(Draft02.RestConfModule.ERROR_INFO_QNAME.getLocalName());
                    jsonWriter.value(value.toString());
                } else {
                    super.leafNode(name, value);
                }
            }
        };
        NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);
        try {
            if (isDataRoot) {
                RestconfDocumentedExceptionMapper.writeDataRoot(outputWriter, nnWriter, (ContainerNode)data);
            } else {
                if (data instanceof MapEntryNode) {
                    data = ImmutableNodes.mapNodeBuilder((QName)data.getNodeType()).withChild((NormalizedNode)((MapEntryNode)data)).build();
                }
                nnWriter.write(data);
            }
            nnWriter.flush();
            outputWriter.flush();
        }
        catch (IOException e) {
            LOG.warn("Error writing error response body", (Throwable)e);
        }
        try {
            return outStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "Failure encoding error response: " + e;
        }
    }

    private static Object toXMLResponseBody(NormalizedNodeContext errorsNode, DataNodeContainer errorsSchemaNode) {
        XMLStreamWriter xmlWriter;
        InstanceIdentifierContext pathContext = errorsNode.getInstanceIdentifierContext();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            xmlWriter = XML_FACTORY.createXMLStreamWriter(outStream, StandardCharsets.UTF_8.name());
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        NormalizedNode data = errorsNode.getData();
        SchemaPath schemaPath = pathContext.getSchemaNode().getPath();
        boolean isDataRoot = false;
        if (SchemaPath.ROOT.equals((Object)schemaPath)) {
            isDataRoot = true;
        } else {
            schemaPath = schemaPath.getParent();
        }
        final NormalizedNodeStreamWriter xmlStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)pathContext.getSchemaContext(), (SchemaPath)schemaPath);
        ForwardingNormalizedNodeStreamWriter streamWriter = new ForwardingNormalizedNodeStreamWriter(){

            protected NormalizedNodeStreamWriter delegate() {
                return xmlStreamWriter;
            }

            public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
                if (name.getNodeType().equals((Object)Draft02.RestConfModule.ERROR_INFO_QNAME)) {
                    String ns = Draft02.RestConfModule.ERROR_INFO_QNAME.getNamespace().toString();
                    try {
                        xmlWriter.writeStartElement("", Draft02.RestConfModule.ERROR_INFO_QNAME.getLocalName(), ns);
                        xmlWriter.writeCharacters(value.toString());
                        xmlWriter.writeEndElement();
                    }
                    catch (XMLStreamException e) {
                        throw new IOException("Error writing error-info", e);
                    }
                } else {
                    super.leafNode(name, value);
                }
            }
        };
        NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);
        try {
            if (isDataRoot) {
                RestconfDocumentedExceptionMapper.writeRootElement(xmlWriter, nnWriter, (ContainerNode)data);
            } else {
                if (data instanceof MapEntryNode) {
                    data = ImmutableNodes.mapNodeBuilder((QName)data.getNodeType()).addChild((NormalizedNode)((MapEntryNode)data)).build();
                }
                nnWriter.write(data);
                nnWriter.flush();
            }
        }
        catch (IOException e) {
            LOG.warn("Error writing error response body.", (Throwable)e);
        }
        try {
            return outStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "Failure encoding error response: " + e;
        }
    }

    private static void writeRootElement(XMLStreamWriter xmlWriter, NormalizedNodeWriter nnWriter, ContainerNode data) throws IOException {
        QName name = SchemaContext.NAME;
        try {
            xmlWriter.writeStartElement(name.getNamespace().toString(), name.getLocalName());
            for (DataContainerChild child : data.getValue()) {
                nnWriter.write((NormalizedNode)child);
            }
            nnWriter.flush();
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to write elements", e);
        }
    }

    private static void writeDataRoot(OutputStreamWriter outputWriter, NormalizedNodeWriter nnWriter, ContainerNode data) throws IOException {
        for (DataContainerChild child : data.getValue()) {
            nnWriter.write((NormalizedNode)child);
            nnWriter.flush();
        }
    }

    static {
        XML_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

