/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class BatchedExistenceCheck {
    private static final AtomicIntegerFieldUpdater<BatchedExistenceCheck> UPDATER = AtomicIntegerFieldUpdater.newUpdater(BatchedExistenceCheck.class, "outstanding");
    private final SettableFuture<Map.Entry<YangInstanceIdentifier, ReadFailedException>> future = SettableFuture.create();
    private volatile int outstanding;

    private BatchedExistenceCheck(int total) {
        this.outstanding = total;
    }

    static BatchedExistenceCheck start(DOMDataTreeReadTransaction readTx, LogicalDatastoreType datastore, YangInstanceIdentifier parentPath, Collection<? extends NormalizedNode<?, ?>> children) {
        final BatchedExistenceCheck ret = new BatchedExistenceCheck(children.size());
        for (NormalizedNode<?, ?> child : children) {
            final YangInstanceIdentifier path = parentPath.node(child.getIdentifier());
            FluentFuture f = readTx.exists(datastore, path);
            Futures.addCallback((ListenableFuture)f, (FutureCallback)new FutureCallback<Boolean>(){

                public void onSuccess(@Nonnull Boolean result) {
                    ret.complete(path, result);
                }

                @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
                public void onFailure(Throwable throwable) {
                    Exception e = throwable instanceof Exception ? (Exception)throwable : new ExecutionException(throwable);
                    ret.complete(path, (ReadFailedException)ReadFailedException.MAPPER.apply(e));
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return ret;
    }

    Map.Entry<YangInstanceIdentifier, ReadFailedException> getFailure() throws InterruptedException {
        try {
            return (Map.Entry)this.future.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private void complete(YangInstanceIdentifier childPath, boolean present) {
        int count = UPDATER.decrementAndGet(this);
        if (present) {
            this.future.set(new AbstractMap.SimpleImmutableEntry<YangInstanceIdentifier, Object>(childPath, null));
        } else if (count == 0) {
            this.future.set(null);
        }
    }

    private void complete(YangInstanceIdentifier childPath, ReadFailedException cause) {
        UPDATER.decrementAndGet(this);
        this.future.set(new AbstractMap.SimpleImmutableEntry<YangInstanceIdentifier, ReadFailedException>(childPath, cause));
    }
}

