/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationException;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationOperation;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizer;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.netconf.sal.restconf.impl.RestCodec;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.util.RestUtil;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControllerContext
implements SchemaContextListener,
Closeable {
    public static final String MOUNT = "yang-ext:mount";
    private static final Logger LOG = LoggerFactory.getLogger(ControllerContext.class);
    private static final String NULL_VALUE = "null";
    private static final String MOUNT_MODULE = "yang-ext";
    private static final String MOUNT_NODE = "mount";
    private static final Charset URI_ENCODING_CHARSET = StandardCharsets.UTF_8;
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private final AtomicReference<Map<QName, RpcDefinition>> qnameToRpc = new AtomicReference(Collections.emptyMap());
    private final DOMMountPointService mountService;
    private final DOMYangTextSourceProvider yangTextSourceProvider;
    private final ListenerRegistration<SchemaContextListener> listenerRegistration;
    private volatile SchemaContext globalSchema;
    private volatile DataNormalizer dataNormalizer;

    private ControllerContext(DOMSchemaService schemaService, DOMMountPointService mountService, DOMYangTextSourceProvider yangTextSourceProvider) {
        this.mountService = mountService;
        this.yangTextSourceProvider = yangTextSourceProvider;
        this.onGlobalContextUpdated(schemaService.getGlobalContext());
        this.listenerRegistration = schemaService.registerSchemaContextListener((SchemaContextListener)this);
    }

    public static ControllerContext newInstance(DOMSchemaService schemaService, DOMMountPointService mountService, DOMSchemaService domSchemaService) {
        DOMYangTextSourceProvider yangTextSourceProvider = (DOMYangTextSourceProvider)domSchemaService.getExtensions().getInstance(DOMYangTextSourceProvider.class);
        return new ControllerContext(schemaService, mountService, yangTextSourceProvider);
    }

    private void setGlobalSchema(SchemaContext globalSchema) {
        this.globalSchema = globalSchema;
        this.dataNormalizer = new DataNormalizer(globalSchema);
    }

    public DOMYangTextSourceProvider getYangTextSourceProvider() {
        return this.yangTextSourceProvider;
    }

    private void checkPreconditions() {
        if (this.globalSchema == null) {
            throw new RestconfDocumentedException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public void close() {
        this.listenerRegistration.close();
    }

    public void setSchemas(SchemaContext schemas) {
        this.onGlobalContextUpdated(schemas);
    }

    public InstanceIdentifierContext<?> toInstanceIdentifier(String restconfInstance) {
        return this.toIdentifier(restconfInstance, false);
    }

    public SchemaContext getGlobalSchema() {
        return this.globalSchema;
    }

    public InstanceIdentifierContext<?> toMountPointIdentifier(String restconfInstance) {
        return this.toIdentifier(restconfInstance, true);
    }

    private InstanceIdentifierContext<?> toIdentifier(String restconfInstance, boolean toMountPointIdentifier) {
        this.checkPreconditions();
        if (restconfInstance == null) {
            return new InstanceIdentifierContext(YangInstanceIdentifier.EMPTY, (SchemaNode)this.globalSchema, null, this.globalSchema);
        }
        List<String> pathArgs = ControllerContext.urlPathArgsDecode(SLASH_SPLITTER.split((CharSequence)restconfInstance));
        ControllerContext.omitFirstAndLastEmptyString(pathArgs);
        if (pathArgs.isEmpty()) {
            return null;
        }
        String first = pathArgs.iterator().next();
        String startModule = ControllerContext.toModuleName(first);
        if (startModule == null) {
            throw new RestconfDocumentedException("First node in URI has to be in format \"moduleName:nodeName\"", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        YangInstanceIdentifier.InstanceIdentifierBuilder builder = YangInstanceIdentifier.builder();
        Set latestModule = this.globalSchema.findModules(startModule);
        if (latestModule.isEmpty()) {
            throw new RestconfDocumentedException("The module named '" + startModule + "' does not exist.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
        }
        InstanceIdentifierContext<?> iiWithSchemaNode = this.collectPathArguments(builder, pathArgs, (DataNodeContainer)latestModule.iterator().next(), null, toMountPointIdentifier);
        if (iiWithSchemaNode == null) {
            throw new RestconfDocumentedException("URI has bad format", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        return iiWithSchemaNode;
    }

    private static List<String> omitFirstAndLastEmptyString(List<String> list) {
        if (list.isEmpty()) {
            return list;
        }
        String head = list.iterator().next();
        if (head.isEmpty()) {
            list.remove(0);
        }
        if (list.isEmpty()) {
            return list;
        }
        String last = list.get(list.size() - 1);
        if (last.isEmpty()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public Module findModuleByName(String moduleName) {
        this.checkPreconditions();
        Preconditions.checkArgument((moduleName != null && !moduleName.isEmpty() ? 1 : 0) != 0);
        return this.globalSchema.findModules(moduleName).stream().findFirst().orElse(null);
    }

    public Module findModuleByName(DOMMountPoint mountPoint, String moduleName) {
        Preconditions.checkArgument((moduleName != null && mountPoint != null ? 1 : 0) != 0);
        SchemaContext mountPointSchema = mountPoint.getSchemaContext();
        if (mountPointSchema == null) {
            return null;
        }
        return mountPointSchema.findModules(moduleName).stream().findFirst().orElse(null);
    }

    public Module findModuleByNamespace(URI namespace) {
        this.checkPreconditions();
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0);
        return this.globalSchema.findModules(namespace).stream().findFirst().orElse(null);
    }

    public Module findModuleByNamespace(DOMMountPoint mountPoint, URI namespace) {
        Preconditions.checkArgument((namespace != null && mountPoint != null ? 1 : 0) != 0);
        SchemaContext mountPointSchema = mountPoint.getSchemaContext();
        if (mountPointSchema == null) {
            return null;
        }
        return mountPointSchema.findModules(namespace).stream().findFirst().orElse(null);
    }

    public Module findModuleByNameAndRevision(String name, Revision revision) {
        this.checkPreconditions();
        Preconditions.checkArgument((name != null && revision != null ? 1 : 0) != 0);
        return this.globalSchema.findModule(name, revision).orElse(null);
    }

    public Module findModuleByNameAndRevision(DOMMountPoint mountPoint, String name, Revision revision) {
        this.checkPreconditions();
        Preconditions.checkArgument((name != null && revision != null && mountPoint != null ? 1 : 0) != 0);
        SchemaContext schemaContext = mountPoint.getSchemaContext();
        return schemaContext == null ? null : (Module)schemaContext.findModule(name, revision).orElse(null);
    }

    public DataNodeContainer getDataNodeContainerFor(YangInstanceIdentifier path) {
        Module initialModule;
        this.checkPreconditions();
        List elements = path.getPathArguments();
        YangInstanceIdentifier.PathArgument head = (YangInstanceIdentifier.PathArgument)elements.iterator().next();
        QName startQName = head.getNodeType();
        Module node = initialModule = (Module)this.globalSchema.findModule(startQName.getModule()).orElse(null);
        for (YangInstanceIdentifier.PathArgument element : elements) {
            QName _nodeType = element.getNodeType();
            DataSchemaNode potentialNode = ControllerContext.childByQName((Object)node, _nodeType);
            if (potentialNode == null || !ControllerContext.isListOrContainer(potentialNode)) {
                return null;
            }
            node = (DataNodeContainer)potentialNode;
        }
        return node;
    }

    public String toFullRestconfIdentifier(YangInstanceIdentifier path, DOMMountPoint mount) {
        Module initialModule;
        this.checkPreconditions();
        List elements = path.getPathArguments();
        StringBuilder builder = new StringBuilder();
        YangInstanceIdentifier.PathArgument head = (YangInstanceIdentifier.PathArgument)elements.iterator().next();
        QName startQName = head.getNodeType();
        SchemaContext schemaContext = mount != null ? mount.getSchemaContext() : this.globalSchema;
        Module node = initialModule = (Module)schemaContext.findModule(startQName.getModule()).orElse(null);
        for (YangInstanceIdentifier.PathArgument element : elements) {
            if (element instanceof YangInstanceIdentifier.AugmentationIdentifier) continue;
            QName _nodeType = element.getNodeType();
            DataSchemaNode potentialNode = ControllerContext.childByQName((Object)node, _nodeType);
            if (element instanceof YangInstanceIdentifier.NodeIdentifier && potentialNode instanceof ListSchemaNode || potentialNode instanceof ChoiceSchemaNode) continue;
            builder.append(this.convertToRestconfIdentifier(element, potentialNode, mount));
            if (!(potentialNode instanceof DataNodeContainer)) continue;
            node = (DataNodeContainer)potentialNode;
        }
        return builder.toString();
    }

    public String findModuleNameByNamespace(URI namespace) {
        this.checkPreconditions();
        Module module = this.findModuleByNamespace(namespace);
        return module == null ? null : module.getName();
    }

    public String findModuleNameByNamespace(DOMMountPoint mountPoint, URI namespace) {
        Module module = this.findModuleByNamespace(mountPoint, namespace);
        return module == null ? null : module.getName();
    }

    public URI findNamespaceByModuleName(String moduleName) {
        Module module = this.findModuleByName(moduleName);
        return module == null ? null : module.getNamespace();
    }

    public URI findNamespaceByModuleName(DOMMountPoint mountPoint, String moduleName) {
        Module module = this.findModuleByName(mountPoint, moduleName);
        return module == null ? null : module.getNamespace();
    }

    public Set<Module> getAllModules(DOMMountPoint mountPoint) {
        this.checkPreconditions();
        SchemaContext schemaContext = mountPoint == null ? null : mountPoint.getSchemaContext();
        return schemaContext == null ? null : schemaContext.getModules();
    }

    public Set<Module> getAllModules() {
        this.checkPreconditions();
        return this.globalSchema.getModules();
    }

    private static CharSequence toRestconfIdentifier(SchemaContext context, QName qname) {
        Module schema = context.findModule(qname.getModule()).orElse(null);
        return schema == null ? null : schema.getName() + ':' + qname.getLocalName();
    }

    public CharSequence toRestconfIdentifier(QName qname, DOMMountPoint mount) {
        SchemaContext schema;
        if (mount != null) {
            schema = mount.getSchemaContext();
        } else {
            this.checkPreconditions();
            schema = this.globalSchema;
        }
        return ControllerContext.toRestconfIdentifier(schema, qname);
    }

    public CharSequence toRestconfIdentifier(QName qname) {
        this.checkPreconditions();
        return ControllerContext.toRestconfIdentifier(this.globalSchema, qname);
    }

    public CharSequence toRestconfIdentifier(DOMMountPoint mountPoint, QName qname) {
        if (mountPoint == null) {
            return null;
        }
        return ControllerContext.toRestconfIdentifier(mountPoint.getSchemaContext(), qname);
    }

    public Module getRestconfModule() {
        return this.findModuleByNameAndRevision("ietf-restconf", Revision.of((String)"2013-10-19"));
    }

    public DataSchemaNode getRestconfModuleErrorsSchemaNode() {
        Module restconfModule = this.getRestconfModule();
        if (restconfModule == null) {
            return null;
        }
        Set groupings = restconfModule.getGroupings();
        Iterable filteredGroups = Iterables.filter((Iterable)groupings, g -> "errors".equals(g.getQName().getLocalName()));
        GroupingDefinition restconfGrouping = (GroupingDefinition)Iterables.getFirst((Iterable)filteredGroups, null);
        List<DataSchemaNode> instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfGrouping, "errors");
        return (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
    }

    public DataSchemaNode getRestconfModuleRestConfSchemaNode(Module inRestconfModule, String schemaNodeName) {
        Module restconfModule = inRestconfModule;
        if (restconfModule == null) {
            restconfModule = this.getRestconfModule();
        }
        if (restconfModule == null) {
            return null;
        }
        Set groupings = restconfModule.getGroupings();
        Iterable filteredGroups = Iterables.filter((Iterable)groupings, g -> "restconf".equals(g.getQName().getLocalName()));
        GroupingDefinition restconfGrouping = (GroupingDefinition)Iterables.getFirst((Iterable)filteredGroups, null);
        List<DataSchemaNode> instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfGrouping, "restconf");
        DataSchemaNode restconfContainer = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        if ("operations".equals(schemaNodeName)) {
            List<DataSchemaNode> instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfContainer, "operations");
            return (DataSchemaNode)Iterables.getFirst(instances, null);
        }
        if ("streams".equals(schemaNodeName)) {
            List<DataSchemaNode> instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfContainer, "streams");
            return (DataSchemaNode)Iterables.getFirst(instances, null);
        }
        if ("stream".equals(schemaNodeName)) {
            List<DataSchemaNode> instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfContainer, "streams");
            DataSchemaNode modules = (DataSchemaNode)Iterables.getFirst(instances, null);
            instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)modules, "stream");
            return (DataSchemaNode)Iterables.getFirst(instances, null);
        }
        if ("modules".equals(schemaNodeName)) {
            List<DataSchemaNode> instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfContainer, "modules");
            return (DataSchemaNode)Iterables.getFirst(instances, null);
        }
        if ("module".equals(schemaNodeName)) {
            List<DataSchemaNode> instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfContainer, "modules");
            DataSchemaNode modules = (DataSchemaNode)Iterables.getFirst(instances, null);
            instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)modules, "module");
            return (DataSchemaNode)Iterables.getFirst(instances, null);
        }
        if ("streams".equals(schemaNodeName)) {
            List<DataSchemaNode> instances = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)restconfContainer, "streams");
            return (DataSchemaNode)Iterables.getFirst(instances, null);
        }
        return null;
    }

    private static DataSchemaNode childByQName(ChoiceSchemaNode container, QName name) {
        for (CaseSchemaNode caze : container.getCases().values()) {
            DataSchemaNode ret = ControllerContext.childByQName(caze, name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static DataSchemaNode childByQName(CaseSchemaNode container, QName name) {
        return container.getDataChildByName(name);
    }

    private static DataSchemaNode childByQName(ContainerSchemaNode container, QName name) {
        return ControllerContext.dataNodeChildByQName((DataNodeContainer)container, name);
    }

    private static DataSchemaNode childByQName(ListSchemaNode container, QName name) {
        return ControllerContext.dataNodeChildByQName((DataNodeContainer)container, name);
    }

    private static DataSchemaNode childByQName(Module container, QName name) {
        return ControllerContext.dataNodeChildByQName((DataNodeContainer)container, name);
    }

    private static DataSchemaNode childByQName(DataSchemaNode container, QName name) {
        return null;
    }

    private static DataSchemaNode childByQName(Object container, QName name) {
        if (container instanceof CaseSchemaNode) {
            return ControllerContext.childByQName((CaseSchemaNode)container, name);
        }
        if (container instanceof ChoiceSchemaNode) {
            return ControllerContext.childByQName((ChoiceSchemaNode)container, name);
        }
        if (container instanceof ContainerSchemaNode) {
            return ControllerContext.childByQName((ContainerSchemaNode)container, name);
        }
        if (container instanceof ListSchemaNode) {
            return ControllerContext.childByQName((ListSchemaNode)container, name);
        }
        if (container instanceof DataSchemaNode) {
            return ControllerContext.childByQName((DataSchemaNode)container, name);
        }
        if (container instanceof Module) {
            return ControllerContext.childByQName((Module)container, name);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(container, name).toString());
    }

    private static DataSchemaNode dataNodeChildByQName(DataNodeContainer container, QName name) {
        DataSchemaNode ret = container.getDataChildByName(name);
        if (ret == null) {
            for (DataSchemaNode node : container.getChildNodes()) {
                ChoiceSchemaNode choiceNode;
                DataSchemaNode childByQName;
                if (!(node instanceof ChoiceSchemaNode) || (childByQName = ControllerContext.childByQName(choiceNode = (ChoiceSchemaNode)node, name)) == null) continue;
                return childByQName;
            }
        }
        return ret;
    }

    private String toUriString(Object object, LeafSchemaNode leafNode, DOMMountPoint mount) throws UnsupportedEncodingException {
        Codec<Object, Object> codec = RestCodec.from(leafNode.getType(), mount, this);
        return object == null ? "" : URLEncoder.encode(codec.serialize(object).toString(), URI_ENCODING_CHARSET.name());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Unrecognised NullableDecl")
    private InstanceIdentifierContext<?> collectPathArguments(YangInstanceIdentifier.InstanceIdentifierBuilder builder, List<String> strings, DataNodeContainer parentNode, DOMMountPoint mountPoint, boolean returnJustMountPoint) {
        Preconditions.checkNotNull(strings);
        if (parentNode == null) {
            return null;
        }
        if (strings.isEmpty()) {
            return ControllerContext.createContext(builder.build(), (DataSchemaNode)parentNode, mountPoint, mountPoint != null ? mountPoint.getSchemaContext() : this.globalSchema);
        }
        String head = strings.iterator().next();
        String nodeName = ControllerContext.toNodeName(head);
        String moduleName = ControllerContext.toModuleName(head);
        DataSchemaNode targetNode = null;
        if (!Strings.isNullOrEmpty((String)moduleName)) {
            if (MOUNT_MODULE.equals(moduleName) && MOUNT_NODE.equals(nodeName)) {
                if (mountPoint != null) {
                    throw new RestconfDocumentedException("Restconf supports just one mount point in URI.", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED);
                }
                if (this.mountService == null) {
                    throw new RestconfDocumentedException("MountService was not found. Finding behind mount points does not work.", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED);
                }
                YangInstanceIdentifier partialPath = this.dataNormalizer.toNormalized(builder.build());
                Optional mountOpt = this.mountService.getMountPoint(partialPath);
                if (!mountOpt.isPresent()) {
                    LOG.debug("Instance identifier to missing mount point: {}", (Object)partialPath);
                    throw new RestconfDocumentedException("Mount point does not exist.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING);
                }
                DOMMountPoint mount = (DOMMountPoint)mountOpt.get();
                SchemaContext mountPointSchema = mount.getSchemaContext();
                if (mountPointSchema == null) {
                    throw new RestconfDocumentedException("Mount point does not contain any schema with modules.", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
                }
                if (returnJustMountPoint || strings.size() == 1) {
                    YangInstanceIdentifier instance = YangInstanceIdentifier.builder().build();
                    return new InstanceIdentifierContext(instance, (SchemaNode)mountPointSchema, mount, mountPointSchema);
                }
                String moduleNameBehindMountPoint = ControllerContext.toModuleName(strings.get(1));
                if (moduleNameBehindMountPoint == null) {
                    throw new RestconfDocumentedException("First node after mount point in URI has to be in format \"moduleName:nodeName\"", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
                }
                Iterator it = mountPointSchema.findModules(moduleNameBehindMountPoint).iterator();
                if (!it.hasNext()) {
                    throw new RestconfDocumentedException("\"" + moduleNameBehindMountPoint + "\" module does not exist in mount point.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
                }
                List<String> subList = strings.subList(1, strings.size());
                return this.collectPathArguments(YangInstanceIdentifier.builder(), subList, (DataNodeContainer)it.next(), mount, returnJustMountPoint);
            }
            Module module = null;
            if (mountPoint == null) {
                this.checkPreconditions();
                module = this.globalSchema.findModules(moduleName).stream().findFirst().orElse(null);
                if (module == null) {
                    throw new RestconfDocumentedException("\"" + moduleName + "\" module does not exist.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
                }
            } else {
                SchemaContext schemaContext = mountPoint.getSchemaContext();
                module = schemaContext != null ? (Module)schemaContext.findModules(moduleName).stream().findFirst().orElse(null) : null;
                if (module == null) {
                    throw new RestconfDocumentedException("\"" + moduleName + "\" module does not exist in mount point.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
                }
            }
            if ((targetNode = ControllerContext.findInstanceDataChildByNameAndNamespace(parentNode, nodeName, module.getNamespace())) == null && parentNode instanceof Module) {
                RpcDefinition rpc;
                if (mountPoint == null) {
                    rpc = this.getRpcDefinition(head, module.getRevision());
                } else {
                    String rpcName = ControllerContext.toNodeName(head);
                    rpc = ControllerContext.getRpcDefinition(module, rpcName);
                }
                if (rpc != null) {
                    return new InstanceIdentifierContext(builder.build(), (SchemaNode)rpc, mountPoint, mountPoint != null ? mountPoint.getSchemaContext() : this.globalSchema);
                }
            }
            if (targetNode == null) {
                throw new RestconfDocumentedException("URI has bad format. Possible reasons:\n 1. \"" + head + "\" was not found in parent data node.\n 2. \"" + head + "\" is behind mount point. Then it should be in format \"/" + MOUNT + "/" + head + "\".", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
            }
        } else {
            List<DataSchemaNode> potentialSchemaNodes = ControllerContext.findInstanceDataChildrenByName(parentNode, nodeName);
            if (potentialSchemaNodes.size() > 1) {
                StringBuilder strBuilder = new StringBuilder();
                for (DataSchemaNode potentialNodeSchema : potentialSchemaNodes) {
                    strBuilder.append("   ").append(potentialNodeSchema.getQName().getNamespace()).append("\n");
                }
                throw new RestconfDocumentedException("URI has bad format. Node \"" + nodeName + "\" is added as augment from more than one module. Therefore the node must have module name and it has to be in format \"moduleName:nodeName\".\nThe node is added as augment from modules with namespaces:\n" + strBuilder.toString(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
            }
            if (potentialSchemaNodes.isEmpty()) {
                throw new RestconfDocumentedException("\"" + nodeName + "\" in URI was not found in parent data node", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
            }
            targetNode = potentialSchemaNodes.iterator().next();
        }
        if (!ControllerContext.isListOrContainer(targetNode)) {
            throw new RestconfDocumentedException("URI has bad format. Node \"" + head + "\" must be Container or List yang type.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        int consumed = 1;
        if (targetNode instanceof ListSchemaNode) {
            ListSchemaNode listNode = (ListSchemaNode)targetNode;
            int keysSize = listNode.getKeyDefinition().size();
            if (strings.size() - consumed < keysSize) {
                throw new RestconfDocumentedException("Missing key for list \"" + listNode.getQName().getLocalName() + "\".", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING);
            }
            List<String> uriKeyValues = strings.subList(consumed, consumed + keysSize);
            LinkedHashMap<QName, Object> keyValues = new LinkedHashMap<QName, Object>();
            int index = 0;
            for (QName key : listNode.getKeyDefinition()) {
                String uriKeyValue = uriKeyValues.get(index);
                if (uriKeyValue.equals(NULL_VALUE)) {
                    throw new RestconfDocumentedException("URI has bad format. List \"" + listNode.getQName().getLocalName() + "\" cannot contain \"null\" value as a key.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
                }
                this.addKeyValue(keyValues, listNode.getDataChildByName(key), uriKeyValue, mountPoint);
                ++index;
            }
            consumed += index;
            builder.nodeWithKey(targetNode.getQName(), keyValues);
        } else {
            builder.node(targetNode.getQName());
        }
        if (targetNode instanceof DataNodeContainer) {
            List<String> remaining = strings.subList(consumed, strings.size());
            return this.collectPathArguments(builder, remaining, (DataNodeContainer)targetNode, mountPoint, returnJustMountPoint);
        }
        return ControllerContext.createContext(builder.build(), targetNode, mountPoint, mountPoint != null ? mountPoint.getSchemaContext() : this.globalSchema);
    }

    private static InstanceIdentifierContext<?> createContext(YangInstanceIdentifier instance, DataSchemaNode dataSchemaNode, DOMMountPoint mountPoint, SchemaContext schemaContext) {
        YangInstanceIdentifier instanceIdentifier = new DataNormalizer(schemaContext).toNormalized(instance);
        return new InstanceIdentifierContext(instanceIdentifier, (SchemaNode)dataSchemaNode, mountPoint, schemaContext);
    }

    public static DataSchemaNode findInstanceDataChildByNameAndNamespace(DataNodeContainer container, String name, URI namespace) {
        Preconditions.checkNotNull((Object)namespace);
        Iterable result = Iterables.filter(ControllerContext.findInstanceDataChildrenByName(container, name), node -> namespace.equals(node.getQName().getNamespace()));
        return (DataSchemaNode)Iterables.getFirst((Iterable)result, null);
    }

    public static List<DataSchemaNode> findInstanceDataChildrenByName(DataNodeContainer container, String name) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)name);
        ArrayList<DataSchemaNode> instantiatedDataNodeContainers = new ArrayList<DataSchemaNode>();
        ControllerContext.collectInstanceDataNodeContainers(instantiatedDataNodeContainers, container, name);
        return instantiatedDataNodeContainers;
    }

    private static void collectInstanceDataNodeContainers(List<DataSchemaNode> potentialSchemaNodes, DataNodeContainer container, String name) {
        Iterable nodes = Iterables.filter((Iterable)container.getChildNodes(), node -> name.equals(node.getQName().getLocalName()));
        for (DataSchemaNode potentialNode : nodes) {
            if (!ControllerContext.isInstantiatedDataSchema(potentialNode)) continue;
            potentialSchemaNodes.add(potentialNode);
        }
        Iterable choiceNodes = Iterables.filter((Iterable)container.getChildNodes(), ChoiceSchemaNode.class);
        Iterable map = Iterables.transform((Iterable)choiceNodes, choice -> choice.getCases().values());
        for (CaseSchemaNode caze : Iterables.concat((Iterable)map)) {
            ControllerContext.collectInstanceDataNodeContainers(potentialSchemaNodes, (DataNodeContainer)caze, name);
        }
    }

    public static boolean isInstantiatedDataSchema(DataSchemaNode node) {
        return node instanceof LeafSchemaNode || node instanceof LeafListSchemaNode || node instanceof ContainerSchemaNode || node instanceof ListSchemaNode || node instanceof AnyXmlSchemaNode;
    }

    private void addKeyValue(Map<QName, Object> map, DataSchemaNode node, String uriValue, DOMMountPoint mountPoint) {
        Preconditions.checkNotNull((Object)uriValue);
        Preconditions.checkArgument((boolean)(node instanceof LeafSchemaNode));
        SchemaContext schemaContext = mountPoint == null ? this.globalSchema : mountPoint.getSchemaContext();
        String urlDecoded = this.urlPathArgDecode(uriValue);
        TypeDefinition typedef = ((LeafSchemaNode)node).getType();
        TypeDefinition baseType = RestUtil.resolveBaseTypeFrom((TypeDefinition)typedef);
        if (baseType instanceof LeafrefTypeDefinition) {
            typedef = SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)((LeafrefTypeDefinition)baseType), (SchemaContext)schemaContext, (SchemaNode)node);
        }
        Codec<Object, Object> codec = RestCodec.from(typedef, mountPoint, this);
        Object decoded = codec.deserialize((Object)urlDecoded);
        String additionalInfo = "";
        if (decoded == null && typedef instanceof IdentityrefTypeDefinition) {
            decoded = this.toQName(schemaContext, urlDecoded);
            additionalInfo = "For key which is of type identityref it should be in format module_name:identity_name.";
        }
        if (decoded == null) {
            throw new RestconfDocumentedException(uriValue + " from URI can't be resolved. " + additionalInfo, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        map.put(node.getQName(), decoded);
    }

    private static String toModuleName(String str) {
        int idx = str.indexOf(58);
        if (idx == -1) {
            return null;
        }
        if (str.indexOf(58, idx + 1) != -1) {
            return null;
        }
        return str.substring(0, idx);
    }

    private static String toNodeName(String str) {
        int idx = str.indexOf(58);
        if (idx == -1) {
            return str;
        }
        if (str.indexOf(58, idx + 1) != -1) {
            return str;
        }
        return str.substring(idx + 1);
    }

    private QName toQName(SchemaContext schemaContext, String name, Optional<Revision> revisionDate) {
        this.checkPreconditions();
        String module = ControllerContext.toModuleName(name);
        String node = ControllerContext.toNodeName(name);
        Module m = schemaContext.findModule(module, revisionDate).orElse(null);
        return m == null ? null : QName.create((QNameModule)m.getQNameModule(), (String)node);
    }

    private QName toQName(SchemaContext schemaContext, String name) {
        this.checkPreconditions();
        String module = ControllerContext.toModuleName(name);
        String node = ControllerContext.toNodeName(name);
        Set modules = schemaContext.findModules(module);
        return modules.isEmpty() ? null : QName.create((QNameModule)((Module)modules.iterator().next()).getQNameModule(), (String)node);
    }

    private static boolean isListOrContainer(DataSchemaNode node) {
        return node instanceof ListSchemaNode || node instanceof ContainerSchemaNode;
    }

    public RpcDefinition getRpcDefinition(String name, Optional<Revision> revisionDate) {
        QName validName = this.toQName(this.globalSchema, name, revisionDate);
        return validName == null ? null : this.qnameToRpc.get().get(validName);
    }

    public RpcDefinition getRpcDefinition(String name) {
        QName validName = this.toQName(this.globalSchema, name);
        return validName == null ? null : this.qnameToRpc.get().get(validName);
    }

    private static RpcDefinition getRpcDefinition(Module module, String rpcName) {
        QName rpcQName = QName.create((QNameModule)module.getQNameModule(), (String)rpcName);
        for (RpcDefinition rpcDefinition : module.getRpcs()) {
            if (!rpcQName.equals((Object)rpcDefinition.getQName())) continue;
            return rpcDefinition;
        }
        return null;
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        if (context != null) {
            Set defs = context.getOperations();
            HashMap<QName, RpcDefinition> newMap = new HashMap<QName, RpcDefinition>(defs.size());
            for (RpcDefinition operation : defs) {
                newMap.put(operation.getQName(), operation);
            }
            this.qnameToRpc.set((Map<QName, RpcDefinition>)ImmutableMap.copyOf(newMap));
            this.setGlobalSchema(context);
        }
    }

    public static List<String> urlPathArgsDecode(Iterable<String> strings) {
        try {
            ArrayList<String> decodedPathArgs = new ArrayList<String>();
            for (String pathArg : strings) {
                String _decode = URLDecoder.decode(pathArg, URI_ENCODING_CHARSET.name());
                decodedPathArgs.add(_decode);
            }
            return decodedPathArgs;
        }
        catch (UnsupportedEncodingException e) {
            throw new RestconfDocumentedException("Invalid URL path '" + strings + "': " + e.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, (Throwable)e);
        }
    }

    public String urlPathArgDecode(String pathArg) {
        if (pathArg != null) {
            try {
                return URLDecoder.decode(pathArg, URI_ENCODING_CHARSET.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RestconfDocumentedException("Invalid URL path arg '" + pathArg + "': " + e.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, (Throwable)e);
            }
        }
        return null;
    }

    private CharSequence convertToRestconfIdentifier(YangInstanceIdentifier.PathArgument argument, DataSchemaNode node, DOMMountPoint mount) {
        if (argument instanceof YangInstanceIdentifier.NodeIdentifier) {
            return this.convertToRestconfIdentifier((YangInstanceIdentifier.NodeIdentifier)argument, mount);
        }
        if (argument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates && node instanceof ListSchemaNode) {
            return this.convertToRestconfIdentifierWithPredicates((YangInstanceIdentifier.NodeIdentifierWithPredicates)argument, (ListSchemaNode)node, mount);
        }
        if (argument != null && node != null) {
            throw new IllegalArgumentException("Conversion of generic path argument is not supported");
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument, node));
    }

    private CharSequence convertToRestconfIdentifier(YangInstanceIdentifier.NodeIdentifier argument, DOMMountPoint node) {
        return "/" + this.toRestconfIdentifier(argument.getNodeType(), node);
    }

    private CharSequence convertToRestconfIdentifierWithPredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates argument, ListSchemaNode node, DOMMountPoint mount) {
        QName nodeType = argument.getNodeType();
        CharSequence nodeIdentifier = this.toRestconfIdentifier(nodeType, mount);
        Map keyValues = argument.getKeyValues();
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        builder.append(nodeIdentifier);
        builder.append('/');
        List keyDefinition = node.getKeyDefinition();
        boolean hasElements = false;
        block2: for (QName key : keyDefinition) {
            for (DataSchemaNode listChild : node.getChildNodes()) {
                if (!listChild.getQName().equals((Object)key)) continue;
                if (!hasElements) {
                    hasElements = true;
                } else {
                    builder.append('/');
                }
                try {
                    Preconditions.checkState((boolean)(listChild instanceof LeafSchemaNode), (String)"List key has to consist of leaves, not %s", (Object)listChild);
                    builder.append(this.toUriString(keyValues.get(key), (LeafSchemaNode)listChild, mount));
                    continue block2;
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Error parsing URI: {}", keyValues.get(key), (Object)e);
                    return null;
                }
            }
        }
        return builder.toString();
    }

    public YangInstanceIdentifier toNormalized(YangInstanceIdentifier legacy) {
        try {
            return this.dataNormalizer.toNormalized(legacy);
        }
        catch (NullPointerException e) {
            throw new RestconfDocumentedException("Data normalizer isn't set. Normalization isn't possible", (Throwable)e);
        }
    }

    public YangInstanceIdentifier toXpathRepresentation(YangInstanceIdentifier instanceIdentifier) {
        try {
            return this.dataNormalizer.toLegacy(instanceIdentifier);
        }
        catch (NullPointerException e) {
            throw new RestconfDocumentedException("Data normalizer isn't set. Normalization isn't possible", (Throwable)e);
        }
        catch (DataNormalizationException e) {
            throw new RestconfDocumentedException("Data normalizer failed. Normalization isn't possible", (Throwable)e);
        }
    }

    public boolean isNodeMixin(YangInstanceIdentifier path) {
        DataNormalizationOperation operation;
        try {
            operation = this.dataNormalizer.getOperation(path);
        }
        catch (DataNormalizationException e) {
            throw new RestconfDocumentedException("Data normalizer failed. Normalization isn't possible", (Throwable)e);
        }
        return operation.isMixin();
    }

    public DataNormalizationOperation<?> getRootOperation() {
        return this.dataNormalizer.getRootOperation();
    }
}

