/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.sal.restconf.impl.FakeRestconfModule;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

class FakeContainerSchemaNode
implements ContainerSchemaNode {
    static final SchemaPath PATH = SchemaPath.create((boolean)true, (QName[])new QName[]{QName.create((QNameModule)FakeRestconfModule.QNAME, (String)"operations").intern()});
    private final Collection<DataSchemaNode> children;

    FakeContainerSchemaNode(Collection<LeafSchemaNode> children) {
        this.children = ImmutableList.copyOf(children);
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Collection<DataSchemaNode> getChildNodes() {
        return this.children;
    }

    public Set<GroupingDefinition> getGroupings() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        for (DataSchemaNode node : this.children) {
            if (!node.getQName().equals((Object)name)) continue;
            return Optional.of(node);
        }
        throw new RestconfDocumentedException(name + " is not in child of " + PATH.getLastComponent());
    }

    public Set<UsesNode> getUses() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return new HashSet<AugmentationSchemaNode>();
    }

    public boolean isAugmenting() {
        return false;
    }

    public boolean isAddedByUses() {
        return false;
    }

    public boolean isConfiguration() {
        return false;
    }

    public QName getQName() {
        return PATH.getLastComponent();
    }

    public SchemaPath getPath() {
        return PATH;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Optional<String> getDescription() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Optional<String> getReference() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Status getStatus() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean isPresenceContainer() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Set<NotificationDefinition> getNotifications() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Set<ActionDefinition> getActions() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Collection<MustDefinition> getMustConstraints() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

