/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.netconf.sal.rest.impl.StringModuleInstanceIdentifierCodec;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.restconf.common.util.IdentityValuesDTO;
import org.opendaylight.restconf.common.util.RestUtil;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.codec.IdentityrefCodec;
import org.opendaylight.yangtools.yang.data.api.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.api.codec.LeafrefCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestCodec {
    private static final Logger LOG = LoggerFactory.getLogger(RestCodec.class);

    private RestCodec() {
    }

    public static Codec<Object, Object> from(TypeDefinition<?> typeDefinition, DOMMountPoint mountPoint, ControllerContext controllerContext) {
        return new ObjectCodec(typeDefinition, mountPoint, controllerContext);
    }

    private static Module getModuleByNamespace(String namespace, DOMMountPoint mountPoint, ControllerContext controllerContext) {
        URI validNamespace = RestCodec.resolveValidNamespace(namespace, mountPoint, controllerContext);
        Module module = null;
        module = mountPoint != null ? controllerContext.findModuleByNamespace(mountPoint, validNamespace) : controllerContext.findModuleByNamespace(validNamespace);
        if (module == null) {
            LOG.info("Module for namespace {} was not found.", (Object)validNamespace);
            return null;
        }
        return module;
    }

    private static URI resolveValidNamespace(String namespace, DOMMountPoint mountPoint, ControllerContext controllerContext) {
        URI validNamespace = mountPoint != null ? controllerContext.findNamespaceByModuleName(mountPoint, namespace) : controllerContext.findNamespaceByModuleName(namespace);
        if (validNamespace == null) {
            validNamespace = URI.create(namespace);
        }
        return validNamespace;
    }

    public static class InstanceIdentifierCodecImpl
    implements InstanceIdentifierCodec<IdentityValuesDTO> {
        private static final Logger LOG = LoggerFactory.getLogger(InstanceIdentifierCodecImpl.class);
        private final DOMMountPoint mountPoint;
        private final ControllerContext controllerContext;

        public InstanceIdentifierCodecImpl(DOMMountPoint mountPoint, ControllerContext controllerContext) {
            this.mountPoint = mountPoint;
            this.controllerContext = controllerContext;
        }

        public IdentityValuesDTO serialize(YangInstanceIdentifier data) {
            IdentityValuesDTO identityValuesDTO = new IdentityValuesDTO();
            for (YangInstanceIdentifier.PathArgument pathArgument : data.getPathArguments()) {
                List<IdentityValuesDTO.Predicate> predicates;
                IdentityValuesDTO.IdentityValue identityValue = InstanceIdentifierCodecImpl.qNameToIdentityValue(pathArgument.getNodeType());
                if (pathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates && identityValue != null) {
                    predicates = InstanceIdentifierCodecImpl.keyValuesToPredicateList(((YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument).getKeyValues());
                    identityValue.setPredicates(predicates);
                } else if (pathArgument instanceof YangInstanceIdentifier.NodeWithValue && identityValue != null) {
                    predicates = new ArrayList<IdentityValuesDTO.Predicate>();
                    String value = String.valueOf(((YangInstanceIdentifier.NodeWithValue)pathArgument).getValue());
                    predicates.add(new IdentityValuesDTO.Predicate(null, value));
                    identityValue.setPredicates(predicates);
                }
                identityValuesDTO.add(identityValue);
            }
            return identityValuesDTO;
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Unrecognised NullableDecl")
        public YangInstanceIdentifier deserialize(IdentityValuesDTO data) {
            ArrayList<YangInstanceIdentifier.NodeIdentifier> result = new ArrayList<YangInstanceIdentifier.NodeIdentifier>();
            IdentityValuesDTO.IdentityValue valueWithNamespace = (IdentityValuesDTO.IdentityValue)data.getValuesWithNamespaces().get(0);
            Module module = RestCodec.getModuleByNamespace(valueWithNamespace.getNamespace(), this.mountPoint, this.controllerContext);
            if (module == null) {
                LOG.info("Module by namespace '{}' of first node in instance-identifier was not found.", (Object)valueWithNamespace.getNamespace());
                LOG.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(valueWithNamespace.getValue()));
                return null;
            }
            Module parentContainer = module;
            List identities = data.getValuesWithNamespaces();
            for (int i = 0; i < identities.size(); ++i) {
                IdentityValuesDTO.IdentityValue identityValue = (IdentityValuesDTO.IdentityValue)identities.get(i);
                URI validNamespace = RestCodec.resolveValidNamespace(identityValue.getNamespace(), this.mountPoint, this.controllerContext);
                DataSchemaNode node = ControllerContext.findInstanceDataChildByNameAndNamespace((DataNodeContainer)parentContainer, identityValue.getValue(), validNamespace);
                if (node == null) {
                    LOG.info("'{}' node was not found in {}", (Object)identityValue, (Object)parentContainer.getChildNodes());
                    LOG.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                    return null;
                }
                QName qName = node.getQName();
                YangInstanceIdentifier.NodeIdentifier pathArgument = null;
                if (identityValue.getPredicates().isEmpty()) {
                    pathArgument = new YangInstanceIdentifier.NodeIdentifier(qName);
                } else if (node instanceof LeafListSchemaNode) {
                    IdentityValuesDTO.Predicate leafListPredicate = (IdentityValuesDTO.Predicate)identityValue.getPredicates().get(0);
                    if (!leafListPredicate.isLeafList()) {
                        LOG.info("Predicate's data is not type of leaf-list. It should be in format \".='value'\"");
                        LOG.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                        return null;
                    }
                    pathArgument = new YangInstanceIdentifier.NodeWithValue(qName, (Object)leafListPredicate.getValue());
                } else if (node instanceof ListSchemaNode) {
                    DataNodeContainer listNode = (DataNodeContainer)node;
                    HashMap<QName, String> predicatesMap = new HashMap<QName, String>();
                    for (IdentityValuesDTO.Predicate predicate : identityValue.getPredicates()) {
                        validNamespace = RestCodec.resolveValidNamespace(predicate.getName().getNamespace(), this.mountPoint, this.controllerContext);
                        DataSchemaNode listKey = ControllerContext.findInstanceDataChildByNameAndNamespace(listNode, predicate.getName().getValue(), validNamespace);
                        predicatesMap.put(listKey.getQName(), predicate.getValue());
                    }
                    pathArgument = new YangInstanceIdentifier.NodeIdentifierWithPredicates(qName, predicatesMap);
                } else {
                    LOG.info("Node {} is not List or Leaf-list.", (Object)node);
                    LOG.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                    return null;
                }
                result.add(pathArgument);
                if (i >= identities.size() - 1) continue;
                if (node instanceof DataNodeContainer) {
                    parentContainer = (DataNodeContainer)node;
                    continue;
                }
                LOG.info("Node {} isn't instance of DataNodeContainer", (Object)node);
                LOG.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                return null;
            }
            return result.isEmpty() ? null : YangInstanceIdentifier.create(result);
        }

        private static List<IdentityValuesDTO.Predicate> keyValuesToPredicateList(Map<QName, Object> keyValues) {
            ArrayList<IdentityValuesDTO.Predicate> result = new ArrayList<IdentityValuesDTO.Predicate>();
            for (Map.Entry<QName, Object> entry : keyValues.entrySet()) {
                QName qualifiedName = entry.getKey();
                Object value = entry.getValue();
                result.add(new IdentityValuesDTO.Predicate(InstanceIdentifierCodecImpl.qNameToIdentityValue(qualifiedName), String.valueOf(value)));
            }
            return result;
        }

        private static IdentityValuesDTO.IdentityValue qNameToIdentityValue(QName qualifiedName) {
            if (qualifiedName != null) {
                return new IdentityValuesDTO.IdentityValue(qualifiedName.getNamespace().toString(), qualifiedName.getLocalName());
            }
            return null;
        }
    }

    public static class LeafrefCodecImpl
    implements LeafrefCodec<String> {
        public String serialize(Object data) {
            return String.valueOf(data);
        }

        public Object deserialize(String data) {
            return data;
        }
    }

    public static class IdentityrefCodecImpl
    implements IdentityrefCodec<IdentityValuesDTO> {
        private static final Logger LOG = LoggerFactory.getLogger(IdentityrefCodecImpl.class);
        private final DOMMountPoint mountPoint;
        private final ControllerContext controllerContext;

        public IdentityrefCodecImpl(DOMMountPoint mountPoint, ControllerContext controllerContext) {
            this.mountPoint = mountPoint;
            this.controllerContext = controllerContext;
        }

        public IdentityValuesDTO serialize(QName data) {
            return new IdentityValuesDTO(data.getNamespace().toString(), data.getLocalName(), null, null);
        }

        public QName deserialize(IdentityValuesDTO data) {
            IdentityValuesDTO.IdentityValue valueWithNamespace = (IdentityValuesDTO.IdentityValue)data.getValuesWithNamespaces().get(0);
            Module module = RestCodec.getModuleByNamespace(valueWithNamespace.getNamespace(), this.mountPoint, this.controllerContext);
            if (module == null) {
                LOG.info("Module was not found for namespace {}", (Object)valueWithNamespace.getNamespace());
                LOG.info("Idenetityref will be translated as NULL for data - {}", (Object)String.valueOf(valueWithNamespace));
                return null;
            }
            return QName.create((URI)module.getNamespace(), (Optional)module.getRevision(), (String)valueWithNamespace.getValue());
        }
    }

    public static final class ObjectCodec
    implements Codec<Object, Object> {
        private static final Logger LOG = LoggerFactory.getLogger(ObjectCodec.class);
        public static final Codec LEAFREF_DEFAULT_CODEC = new LeafrefCodecImpl();
        private final ControllerContext controllerContext;
        private final Codec instanceIdentifier;
        private final Codec identityrefCodec;
        private final TypeDefinition<?> type;

        private ObjectCodec(TypeDefinition<?> typeDefinition, DOMMountPoint mountPoint, ControllerContext controllerContext) {
            this.controllerContext = controllerContext;
            this.type = RestUtil.resolveBaseTypeFrom(typeDefinition);
            this.identityrefCodec = this.type instanceof IdentityrefTypeDefinition ? new IdentityrefCodecImpl(mountPoint, controllerContext) : null;
            this.instanceIdentifier = this.type instanceof InstanceIdentifierTypeDefinition ? new InstanceIdentifierCodecImpl(mountPoint, controllerContext) : null;
        }

        public Object deserialize(Object input) {
            try {
                if (this.type instanceof IdentityrefTypeDefinition) {
                    if (input instanceof IdentityValuesDTO) {
                        return this.identityrefCodec.deserialize(input);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value is not instance of IdentityrefTypeDefinition but is {}. Therefore NULL is used as translation of  - {}", input == null ? "null" : input.getClass(), (Object)String.valueOf(input));
                    }
                    return null;
                }
                if (this.type instanceof InstanceIdentifierTypeDefinition) {
                    if (input instanceof IdentityValuesDTO) {
                        return this.instanceIdentifier.deserialize(input);
                    }
                    StringModuleInstanceIdentifierCodec codec = new StringModuleInstanceIdentifierCodec(this.controllerContext.getGlobalSchema());
                    return codec.deserialize((String)input);
                }
                TypeDefinitionAwareCodec typeAwarecodec = TypeDefinitionAwareCodec.from(this.type);
                if (typeAwarecodec != null) {
                    if (input instanceof IdentityValuesDTO) {
                        return typeAwarecodec.deserialize(((IdentityValuesDTO)input).getOriginValue());
                    }
                    return typeAwarecodec.deserialize(String.valueOf(input));
                }
                LOG.debug("Codec for type \"{}\" is not implemented yet.", (Object)this.type.getQName().getLocalName());
                return null;
            }
            catch (ClassCastException e) {
                LOG.error("ClassCastException was thrown when codec is invoked with parameter {}", input, (Object)e);
                return null;
            }
        }

        public Object serialize(Object input) {
            try {
                if (this.type instanceof IdentityrefTypeDefinition) {
                    return this.identityrefCodec.serialize(input);
                }
                if (this.type instanceof LeafrefTypeDefinition) {
                    return LEAFREF_DEFAULT_CODEC.serialize(input);
                }
                if (this.type instanceof InstanceIdentifierTypeDefinition) {
                    return this.instanceIdentifier.serialize(input);
                }
                TypeDefinitionAwareCodec typeAwarecodec = TypeDefinitionAwareCodec.from(this.type);
                if (typeAwarecodec != null) {
                    return typeAwarecodec.serialize(input);
                }
                LOG.debug("Codec for type \"{}\" is not implemented yet.", (Object)this.type.getQName().getLocalName());
                return null;
            }
            catch (ClassCastException e) {
                LOG.error("ClassCastException was thrown when codec is invoked with parameter {}", input, (Object)e);
                return input;
            }
        }
    }
}

