/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.sal.rest.api.RestconfService;
import org.opendaylight.netconf.sal.restconf.impl.BrokerFacade;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.netconf.sal.restconf.impl.FakeContainerSchemaNode;
import org.opendaylight.netconf.sal.restconf.impl.FakeImportedModule;
import org.opendaylight.netconf.sal.restconf.impl.FakeLeafSchemaNode;
import org.opendaylight.netconf.sal.restconf.impl.FakeRestconfModule;
import org.opendaylight.netconf.sal.restconf.impl.PutResult;
import org.opendaylight.netconf.sal.restconf.impl.QueryParametersParser;
import org.opendaylight.netconf.sal.streams.listeners.ListenerAdapter;
import org.opendaylight.netconf.sal.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.netconf.sal.streams.listeners.Notificator;
import org.opendaylight.netconf.sal.streams.websockets.WebSocketServer;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.util.DataChangeScope;
import org.opendaylight.restconf.common.validation.RestconfValidationUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.sal.restconf.event.subscription.rev140708.NotificationOutputTypeGrouping;
import org.opendaylight.yangtools.yang.common.OperationFailedException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModifiedNodeDoesNotExistException;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SimpleSchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestconfImpl
implements RestconfService {
    private static final int NOTIFICATION_PORT = 8181;
    private static final int CHAR_NOT_FOUND = -1;
    private static final String SAL_REMOTE_NAMESPACE = "urn:opendaylight:params:xml:ns:yang:controller:md:sal:remote";
    private static final Logger LOG = LoggerFactory.getLogger(RestconfImpl.class);
    private static final DataChangeScope DEFAULT_SCOPE = DataChangeScope.BASE;
    private static final LogicalDatastoreType DEFAULT_DATASTORE = LogicalDatastoreType.CONFIGURATION;
    private static final URI NAMESPACE_EVENT_SUBSCRIPTION_AUGMENT = URI.create("urn:sal:restconf:event:subscription");
    private static final String DATASTORE_PARAM_NAME = "datastore";
    private static final String SCOPE_PARAM_NAME = "scope";
    private static final String OUTPUT_TYPE_PARAM_NAME = "notification-output-type";
    private static final String NETCONF_BASE = "urn:ietf:params:xml:ns:netconf:base:1.0";
    private static final String NETCONF_BASE_PAYLOAD_NAME = "data";
    private static final QName NETCONF_BASE_QNAME = QName.create((QNameModule)QNameModule.create((URI)URI.create("urn:ietf:params:xml:ns:netconf:base:1.0")), (String)"data").intern();
    private static final QNameModule SAL_REMOTE_AUGMENT = QNameModule.create((URI)NAMESPACE_EVENT_SUBSCRIPTION_AUGMENT, (Revision)Revision.of((String)"2014-07-08"));
    private static final YangInstanceIdentifier.AugmentationIdentifier SAL_REMOTE_AUG_IDENTIFIER = new YangInstanceIdentifier.AugmentationIdentifier((Set)ImmutableSet.of((Object)QName.create((QNameModule)SAL_REMOTE_AUGMENT, (String)"scope"), (Object)QName.create((QNameModule)SAL_REMOTE_AUGMENT, (String)"datastore"), (Object)QName.create((QNameModule)SAL_REMOTE_AUGMENT, (String)"notification-output-type")));
    public static final CharSequence DATA_SUBSCR = "data-change-event-subscription";
    private static final CharSequence CREATE_DATA_SUBSCR = "create-" + DATA_SUBSCR;
    public static final CharSequence NOTIFICATION_STREAM = "notification-stream";
    private static final CharSequence CREATE_NOTIFICATION_STREAM = "create-" + NOTIFICATION_STREAM;
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffset("+HH:MM", "Z").toFormatter();
    private final BrokerFacade broker;
    private final ControllerContext controllerContext;

    private RestconfImpl(BrokerFacade broker, ControllerContext controllerContext) {
        this.broker = broker;
        this.controllerContext = controllerContext;
    }

    public static RestconfImpl newInstance(BrokerFacade broker, ControllerContext controllerContext) {
        return new RestconfImpl(broker, controllerContext);
    }

    @Override
    public NormalizedNodeContext getModules(UriInfo uriInfo) {
        Set<Module> allModules = this.controllerContext.getAllModules();
        MapNode allModuleMap = this.makeModuleMapNode(allModules);
        SchemaContext schemaContext = this.controllerContext.getGlobalSchema();
        Module restconfModule = this.getRestconfModule();
        DataSchemaNode modulesSchemaNode = this.controllerContext.getRestconfModuleRestConfSchemaNode(restconfModule, "modules");
        Preconditions.checkState((boolean)(modulesSchemaNode instanceof ContainerSchemaNode));
        DataContainerNodeAttrBuilder moduleContainerBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)modulesSchemaNode));
        moduleContainerBuilder.withChild((DataContainerChild)allModuleMap);
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)modulesSchemaNode, null, schemaContext), moduleContainerBuilder.build(), QueryParametersParser.parseWriterParameters(uriInfo));
    }

    @Override
    public NormalizedNodeContext getModules(String identifier, UriInfo uriInfo) {
        Preconditions.checkNotNull((Object)identifier);
        if (!identifier.contains("yang-ext:mount")) {
            String errMsg = "URI has bad format. If modules behind mount point should be showed, URI has to end with yang-ext:mount";
            LOG.debug("{} for {}", (Object)"URI has bad format. If modules behind mount point should be showed, URI has to end with yang-ext:mount", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. If modules behind mount point should be showed, URI has to end with yang-ext:mount", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        InstanceIdentifierContext<?> mountPointIdentifier = this.controllerContext.toMountPointIdentifier(identifier);
        DOMMountPoint mountPoint = mountPointIdentifier.getMountPoint();
        Set<Module> modules = this.controllerContext.getAllModules(mountPoint);
        MapNode mountPointModulesMap = this.makeModuleMapNode(modules);
        Module restconfModule = this.getRestconfModule();
        DataSchemaNode modulesSchemaNode = this.controllerContext.getRestconfModuleRestConfSchemaNode(restconfModule, "modules");
        Preconditions.checkState((boolean)(modulesSchemaNode instanceof ContainerSchemaNode));
        DataContainerNodeAttrBuilder moduleContainerBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)modulesSchemaNode));
        moduleContainerBuilder.withChild((DataContainerChild)mountPointModulesMap);
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)modulesSchemaNode, mountPoint, this.controllerContext.getGlobalSchema()), moduleContainerBuilder.build(), QueryParametersParser.parseWriterParameters(uriInfo));
    }

    @Override
    public NormalizedNodeContext getModule(String identifier, UriInfo uriInfo) {
        SchemaContext schemaContext;
        Preconditions.checkNotNull((Object)identifier);
        Map.Entry<String, Revision> nameRev = RestconfImpl.getModuleNameAndRevision(identifier);
        Module module = null;
        DOMMountPoint mountPoint = null;
        if (identifier.contains("yang-ext:mount")) {
            InstanceIdentifierContext<?> mountPointIdentifier = this.controllerContext.toMountPointIdentifier(identifier);
            mountPoint = mountPointIdentifier.getMountPoint();
            module = this.controllerContext.findModuleByNameAndRevision(mountPoint, nameRev.getKey(), nameRev.getValue());
            schemaContext = mountPoint.getSchemaContext();
        } else {
            module = this.controllerContext.findModuleByNameAndRevision(nameRev.getKey(), nameRev.getValue());
            schemaContext = this.controllerContext.getGlobalSchema();
        }
        if (module == null) {
            LOG.debug("Module with name '{}' and revision '{}' was not found.", (Object)nameRev.getKey(), (Object)nameRev.getValue());
            throw new RestconfDocumentedException("Module with name '" + nameRev.getKey() + "' and revision '" + nameRev.getValue() + "' was not found.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
        }
        Module restconfModule = this.getRestconfModule();
        Set<Module> modules = Collections.singleton(module);
        MapNode moduleMap = this.makeModuleMapNode(modules);
        DataSchemaNode moduleSchemaNode = this.controllerContext.getRestconfModuleRestConfSchemaNode(restconfModule, "module");
        Preconditions.checkState((boolean)(moduleSchemaNode instanceof ListSchemaNode));
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)moduleSchemaNode, mountPoint, schemaContext), (NormalizedNode)moduleMap, QueryParametersParser.parseWriterParameters(uriInfo));
    }

    @Override
    public NormalizedNodeContext getAvailableStreams(UriInfo uriInfo) {
        SchemaContext schemaContext = this.controllerContext.getGlobalSchema();
        Set<String> availableStreams = Notificator.getStreamNames();
        Module restconfModule = this.getRestconfModule();
        DataSchemaNode streamSchemaNode = this.controllerContext.getRestconfModuleRestConfSchemaNode(restconfModule, "stream");
        Preconditions.checkState((boolean)(streamSchemaNode instanceof ListSchemaNode));
        CollectionNodeBuilder listStreamsBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)streamSchemaNode));
        for (String streamName : availableStreams) {
            listStreamsBuilder.withChild((NormalizedNode)this.toStreamEntryNode(streamName, streamSchemaNode));
        }
        DataSchemaNode streamsContainerSchemaNode = this.controllerContext.getRestconfModuleRestConfSchemaNode(restconfModule, "streams");
        Preconditions.checkState((boolean)(streamsContainerSchemaNode instanceof ContainerSchemaNode));
        DataContainerNodeAttrBuilder streamsContainerBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)streamsContainerSchemaNode));
        streamsContainerBuilder.withChild((DataContainerChild)listStreamsBuilder.build());
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)streamsContainerSchemaNode, null, schemaContext), streamsContainerBuilder.build(), QueryParametersParser.parseWriterParameters(uriInfo));
    }

    @Override
    public NormalizedNodeContext getOperations(UriInfo uriInfo) {
        Set<Module> allModules = this.controllerContext.getAllModules();
        return RestconfImpl.operationsFromModulesToNormalizedContext(allModules, null);
    }

    @Override
    public NormalizedNodeContext getOperations(String identifier, UriInfo uriInfo) {
        Set<Module> modules = null;
        DOMMountPoint mountPoint = null;
        if (!identifier.contains("yang-ext:mount")) {
            String errMsg = "URI has bad format. If operations behind mount point should be showed, URI has to  end with yang-ext:mount";
            LOG.debug("{} for {}", (Object)"URI has bad format. If operations behind mount point should be showed, URI has to  end with yang-ext:mount", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. If operations behind mount point should be showed, URI has to  end with yang-ext:mount", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        InstanceIdentifierContext<?> mountPointIdentifier = this.controllerContext.toMountPointIdentifier(identifier);
        mountPoint = mountPointIdentifier.getMountPoint();
        modules = this.controllerContext.getAllModules(mountPoint);
        return RestconfImpl.operationsFromModulesToNormalizedContext(modules, mountPoint);
    }

    private static NormalizedNodeContext operationsFromModulesToNormalizedContext(Set<Module> modules, DOMMountPoint mountPoint) {
        ArrayList<Module> neededModules = new ArrayList<Module>(modules.size());
        ArrayList<LeafSchemaNode> fakeRpcSchema = new ArrayList<LeafSchemaNode>();
        for (Module m : modules) {
            Set rpcs = m.getRpcs();
            if (rpcs.isEmpty()) continue;
            neededModules.add(m);
            fakeRpcSchema.ensureCapacity(fakeRpcSchema.size() + rpcs.size());
            rpcs.forEach(rpc -> fakeRpcSchema.add(new FakeLeafSchemaNode(rpc.getQName())));
        }
        FakeContainerSchemaNode fakeCont = new FakeContainerSchemaNode(fakeRpcSchema);
        DataContainerNodeAttrBuilder containerBuilder = Builders.containerBuilder((ContainerSchemaNode)fakeCont);
        for (LeafSchemaNode leaf : fakeRpcSchema) {
            containerBuilder.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)leaf).build());
        }
        ArrayList<FakeRestconfModule> fakeModules = new ArrayList<FakeRestconfModule>(neededModules.size() + 1);
        neededModules.forEach(imp -> fakeModules.add((FakeRestconfModule)((Object)new FakeImportedModule((Module)imp))));
        fakeModules.add(new FakeRestconfModule(neededModules, fakeCont));
        SimpleSchemaContext fakeSchemaCtx = SimpleSchemaContext.forModules((Set)ImmutableSet.copyOf(fakeModules));
        InstanceIdentifierContext instanceIdentifierContext = new InstanceIdentifierContext(null, (SchemaNode)fakeCont, mountPoint, (SchemaContext)fakeSchemaCtx);
        return new NormalizedNodeContext(instanceIdentifierContext, containerBuilder.build());
    }

    private Module getRestconfModule() {
        Module restconfModule = this.controllerContext.getRestconfModule();
        if (restconfModule == null) {
            LOG.debug("ietf-restconf module was not found.");
            throw new RestconfDocumentedException("ietf-restconf module was not found.", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED);
        }
        return restconfModule;
    }

    private static Map.Entry<String, Revision> getModuleNameAndRevision(String identifier) {
        int mountIndex = identifier.indexOf("yang-ext:mount");
        String moduleNameAndRevision = "";
        moduleNameAndRevision = mountIndex >= 0 ? identifier.substring(mountIndex + "yang-ext:mount".length()) : identifier;
        Splitter splitter = Splitter.on((char)'/').omitEmptyStrings();
        List pathArgs = splitter.splitToList((CharSequence)moduleNameAndRevision);
        if (pathArgs.size() < 2) {
            LOG.debug("URI has bad format. It should be 'moduleName/yyyy-MM-dd' {}", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. End of URI should be in format 'moduleName/yyyy-MM-dd'", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        try {
            return new AbstractMap.SimpleImmutableEntry<String, Revision>((String)pathArgs.get(0), Revision.of((String)((String)pathArgs.get(1))));
        }
        catch (DateTimeParseException e) {
            LOG.debug("URI has bad format. It should be 'moduleName/yyyy-MM-dd' {}", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. It should be 'moduleName/yyyy-MM-dd'", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, (Throwable)e);
        }
    }

    @Override
    public Object getRoot() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public NormalizedNodeContext invokeRpc(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        NormalizedNode resultData;
        FluentFuture response;
        SchemaContext schemaContext;
        if (payload == null) {
            return this.invokeRpc(identifier, "", uriInfo);
        }
        SchemaPath type = payload.getInstanceIdentifierContext().getSchemaNode().getPath();
        URI namespace = payload.getInstanceIdentifierContext().getSchemaNode().getQName().getNamespace();
        DOMMountPoint mountPoint = payload.getInstanceIdentifierContext().getMountPoint();
        if (mountPoint != null) {
            Optional mountRpcServices = mountPoint.getService(DOMRpcService.class);
            if (!mountRpcServices.isPresent()) {
                LOG.debug("Error: Rpc service is missing.");
                throw new RestconfDocumentedException("Rpc service is missing.");
            }
            schemaContext = mountPoint.getSchemaContext();
            response = ((DOMRpcService)mountRpcServices.get()).invokeRpc(type, payload.getData());
        } else {
            if (namespace.toString().equals(SAL_REMOTE_NAMESPACE)) {
                if (identifier.contains(CREATE_DATA_SUBSCR)) {
                    response = this.invokeSalRemoteRpcSubscribeRPC(payload);
                } else {
                    if (!identifier.contains(CREATE_NOTIFICATION_STREAM)) {
                        String msg = "Not supported operation";
                        LOG.warn("Not supported operation");
                        throw new RestconfDocumentedException("Not supported operation", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED);
                    }
                    response = this.invokeSalRemoteRpcNotifiStrRPC(payload);
                }
            } else {
                response = this.broker.invokeRpc(type, payload.getData());
            }
            schemaContext = this.controllerContext.getGlobalSchema();
        }
        DOMRpcResult result = RestconfImpl.checkRpcResponse((ListenableFuture<DOMRpcResult>)response);
        RpcDefinition resultNodeSchema = null;
        if (result != null && result.getResult() != null) {
            resultData = result.getResult();
            resultNodeSchema = (RpcDefinition)payload.getInstanceIdentifierContext().getSchemaNode();
            return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)resultNodeSchema, mountPoint, schemaContext), resultData, QueryParametersParser.parseWriterParameters(uriInfo));
        }
        resultData = null;
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)resultNodeSchema, mountPoint, schemaContext), resultData, QueryParametersParser.parseWriterParameters(uriInfo));
    }

    @Override
    public NormalizedNodeContext invokeRpc(String identifier, String noPayload, UriInfo uriInfo) {
        FluentFuture response;
        SchemaContext schemaContext;
        if (noPayload != null && !CharMatcher.whitespace().matchesAllOf((CharSequence)noPayload)) {
            throw new RestconfDocumentedException("Content must be empty.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        String identifierEncoded = null;
        DOMMountPoint mountPoint = null;
        if (identifier.contains("yang-ext:mount")) {
            String remoteRpcName;
            InstanceIdentifierContext<?> mountPointId = this.controllerContext.toMountPointIdentifier(identifier);
            mountPoint = mountPointId.getMountPoint();
            schemaContext = mountPoint.getSchemaContext();
            int startOfRemoteRpcName = identifier.lastIndexOf("yang-ext:mount") + "yang-ext:mount".length() + 1;
            identifierEncoded = remoteRpcName = identifier.substring(startOfRemoteRpcName);
        } else {
            if (identifier.indexOf(47) != -1) {
                LOG.debug("Identifier {} cannot contain slash character (/).", (Object)identifier);
                throw new RestconfDocumentedException(String.format("Identifier %n%s%ncan't contain slash character (/).%nIf slash is part of identifier name then use %%2F placeholder.", identifier), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
            }
            identifierEncoded = identifier;
            schemaContext = this.controllerContext.getGlobalSchema();
        }
        String identifierDecoded = this.controllerContext.urlPathArgDecode(identifierEncoded);
        RpcDefinition rpc = null;
        rpc = mountPoint == null ? this.controllerContext.getRpcDefinition(identifierDecoded) : RestconfImpl.findRpc(mountPoint.getSchemaContext(), identifierDecoded);
        if (rpc == null) {
            LOG.debug("RPC {} does not exist.", (Object)identifierDecoded);
            throw new RestconfDocumentedException("RPC does not exist.", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
        }
        if (!rpc.getInput().getChildNodes().isEmpty()) {
            LOG.debug("RPC {} does not need input value.", (Object)rpc);
            throw new RestconfDocumentedException("RPC " + rpc + " does not take any input value.", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.INVALID_VALUE);
        }
        if (mountPoint != null) {
            Optional mountRpcServices = mountPoint.getService(DOMRpcService.class);
            if (!mountRpcServices.isPresent()) {
                throw new RestconfDocumentedException("Rpc service is missing.");
            }
            response = ((DOMRpcService)mountRpcServices.get()).invokeRpc(rpc.getPath(), null);
        } else {
            response = this.broker.invokeRpc(rpc.getPath(), null);
        }
        DOMRpcResult result = RestconfImpl.checkRpcResponse(response);
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, (SchemaNode)rpc, mountPoint, schemaContext), result.getResult(), QueryParametersParser.parseWriterParameters(uriInfo));
    }

    private static DOMRpcResult checkRpcResponse(ListenableFuture<DOMRpcResult> response) {
        if (response == null) {
            return null;
        }
        try {
            DOMRpcResult retValue = (DOMRpcResult)response.get();
            if (retValue.getErrors().isEmpty()) {
                return retValue;
            }
            LOG.debug("RpcError message {}", (Object)retValue.getErrors());
            throw new RestconfDocumentedException("RpcError message", null, retValue.getErrors());
        }
        catch (InterruptedException e) {
            String errMsg = "The operation was interrupted while executing and did not complete.";
            LOG.debug("Rpc Interrupt - {}", (Object)"The operation was interrupted while executing and did not complete.", (Object)e);
            throw new RestconfDocumentedException("The operation was interrupted while executing and did not complete.", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.PARTIAL_OPERATION, (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.debug("Execution RpcError: ", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof IllegalArgumentException) {
                    throw new RestconfDocumentedException(cause.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
                }
                if (cause instanceof DOMRpcImplementationNotAvailableException) {
                    throw new RestconfDocumentedException(cause.getMessage(), RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED);
                }
                throw new RestconfDocumentedException("The operation encountered an unexpected error while executing.", cause);
            }
            throw new RestconfDocumentedException("The operation encountered an unexpected error while executing.", (Throwable)e);
        }
        catch (CancellationException e) {
            String errMsg = "The operation was cancelled while executing.";
            LOG.debug("Cancel RpcExecution: {}", (Object)"The operation was cancelled while executing.", (Object)e);
            throw new RestconfDocumentedException("The operation was cancelled while executing.", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.PARTIAL_OPERATION);
        }
    }

    private static void validateInput(SchemaNode inputSchema, NormalizedNodeContext payload) {
        if (inputSchema != null && payload.getData() == null) {
            throw new RestconfDocumentedException("Input is required.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        if (inputSchema == null && payload.getData() != null) {
            throw new RestconfDocumentedException("No input expected.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
    }

    private ListenableFuture<DOMRpcResult> invokeSalRemoteRpcSubscribeRPC(NormalizedNodeContext payload) {
        Object pathValue;
        ContainerNode value = (ContainerNode)payload.getData();
        QName rpcQName = payload.getInstanceIdentifierContext().getSchemaNode().getQName();
        Optional path = value.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)payload.getInstanceIdentifierContext().getSchemaNode().getQName(), (String)"path")));
        Object object = pathValue = path.isPresent() ? ((DataContainerChild)path.get()).getValue() : null;
        if (!(pathValue instanceof YangInstanceIdentifier)) {
            LOG.debug("Instance identifier {} was not normalized correctly", (Object)rpcQName);
            throw new RestconfDocumentedException("Instance identifier was not normalized correctly", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED);
        }
        YangInstanceIdentifier pathIdentifier = (YangInstanceIdentifier)pathValue;
        String streamName = (String)CREATE_DATA_SUBSCR;
        NotificationOutputTypeGrouping.NotificationOutputType outputType = null;
        if (!pathIdentifier.isEmpty()) {
            String fullRestconfIdentifier = DATA_SUBSCR + this.controllerContext.toFullRestconfIdentifier(pathIdentifier, null);
            LogicalDatastoreType datastore = RestconfImpl.parseEnumTypeParameter(value, LogicalDatastoreType.class, DATASTORE_PARAM_NAME);
            datastore = datastore == null ? DEFAULT_DATASTORE : datastore;
            DataChangeScope scope = RestconfImpl.parseEnumTypeParameter(value, DataChangeScope.class, SCOPE_PARAM_NAME);
            scope = scope == null ? DEFAULT_SCOPE : scope;
            outputType = RestconfImpl.parseEnumTypeParameter(value, NotificationOutputTypeGrouping.NotificationOutputType.class, OUTPUT_TYPE_PARAM_NAME);
            outputType = outputType == null ? NotificationOutputTypeGrouping.NotificationOutputType.XML : outputType;
            streamName = Notificator.createStreamNameFromUri(fullRestconfIdentifier + "/datastore=" + datastore + "/scope=" + scope);
        }
        if (Strings.isNullOrEmpty((String)streamName)) {
            LOG.debug("Path is empty or contains value node which is not Container or List built-in type at {}", (Object)pathIdentifier);
            throw new RestconfDocumentedException("Path is empty or contains value node which is not Container or List built-in type.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        QName outputQname = QName.create((QName)rpcQName, (String)"output");
        QName streamNameQname = QName.create((QName)rpcQName, (String)"stream-name");
        ContainerNode output = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(outputQname)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)streamNameQname, (Object)streamName)).build();
        if (!Notificator.existListenerFor(streamName)) {
            Notificator.createListener(pathIdentifier, streamName, outputType, this.controllerContext);
        }
        return Futures.immediateFuture((Object)new DefaultDOMRpcResult((NormalizedNode)output));
    }

    private static RpcDefinition findRpc(SchemaContext schemaContext, String identifierDecoded) {
        String[] splittedIdentifier = identifierDecoded.split(":");
        if (splittedIdentifier.length != 2) {
            LOG.debug("{} could not be split to 2 parts (module:rpc name)", (Object)identifierDecoded);
            throw new RestconfDocumentedException(identifierDecoded + " could not be split to 2 parts (module:rpc name)", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.INVALID_VALUE);
        }
        for (Module module : schemaContext.getModules()) {
            if (!module.getName().equals(splittedIdentifier[0])) continue;
            for (RpcDefinition rpcDefinition : module.getRpcs()) {
                if (!rpcDefinition.getQName().getLocalName().equals(splittedIdentifier[1])) continue;
                return rpcDefinition;
            }
        }
        return null;
    }

    @Override
    public NormalizedNodeContext readConfigurationData(String identifier, UriInfo uriInfo) {
        boolean withDefaUsed = false;
        String withDefa = null;
        block6: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            switch ((String)entry.getKey()) {
                case "with-defaults": {
                    if (!withDefaUsed) {
                        withDefaUsed = true;
                        withDefa = (String)((List)entry.getValue()).iterator().next();
                        continue block6;
                    }
                    throw new RestconfDocumentedException("With-defaults parameter can be used only once.");
                }
            }
            LOG.info("Unknown key : {}.", entry.getKey());
        }
        boolean tagged = false;
        if (withDefaUsed) {
            if ("report-all-tagged".equals(withDefa)) {
                tagged = true;
                withDefa = null;
            }
            if ("report-all".equals(withDefa)) {
                withDefa = null;
            }
        }
        InstanceIdentifierContext<?> iiWithData = this.controllerContext.toInstanceIdentifier(identifier);
        DOMMountPoint mountPoint = iiWithData.getMountPoint();
        NormalizedNode<?, ?> data = null;
        YangInstanceIdentifier normalizedII = iiWithData.getInstanceIdentifier();
        data = mountPoint != null ? this.broker.readConfigurationData(mountPoint, normalizedII, withDefa) : this.broker.readConfigurationData(normalizedII, withDefa);
        if (data == null) {
            throw RestconfImpl.dataMissing(identifier);
        }
        return new NormalizedNodeContext(iiWithData, data, QueryParametersParser.parseWriterParameters(uriInfo, tagged));
    }

    @Override
    public NormalizedNodeContext readOperationalData(String identifier, UriInfo uriInfo) {
        InstanceIdentifierContext<?> iiWithData = this.controllerContext.toInstanceIdentifier(identifier);
        DOMMountPoint mountPoint = iiWithData.getMountPoint();
        NormalizedNode<?, ?> data = null;
        YangInstanceIdentifier normalizedII = iiWithData.getInstanceIdentifier();
        data = mountPoint != null ? this.broker.readOperationalData(mountPoint, normalizedII) : this.broker.readOperationalData(normalizedII);
        if (data == null) {
            throw RestconfImpl.dataMissing(identifier);
        }
        return new NormalizedNodeContext(iiWithData, data, QueryParametersParser.parseWriterParameters(uriInfo));
    }

    private static RestconfDocumentedException dataMissing(String identifier) {
        LOG.debug("Request could not be completed because the relevant data model content does not exist {}", (Object)identifier);
        return new RestconfDocumentedException("Request could not be completed because the relevant data model content does not exist", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.DATA_MISSING);
    }

    @Override
    public Response updateConfigurationData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        boolean insertUsed = false;
        boolean pointUsed = false;
        String insert = null;
        String point = null;
        block11: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            switch ((String)entry.getKey()) {
                case "insert": {
                    if (!insertUsed) {
                        insertUsed = true;
                        insert = (String)((List)entry.getValue()).iterator().next();
                        continue block11;
                    }
                    throw new RestconfDocumentedException("Insert parameter can be used only once.");
                }
                case "point": {
                    if (!pointUsed) {
                        pointUsed = true;
                        point = (String)((List)entry.getValue()).iterator().next();
                        continue block11;
                    }
                    throw new RestconfDocumentedException("Point parameter can be used only once.");
                }
            }
            throw new RestconfDocumentedException("Bad parameter for post: " + (String)entry.getKey());
        }
        if (pointUsed && !insertUsed) {
            throw new RestconfDocumentedException("Point parameter can't be used without Insert parameter.");
        }
        if (pointUsed && (insert.equals("first") || insert.equals("last"))) {
            throw new RestconfDocumentedException("Point parameter can be used only with 'after' or 'before' values of Insert parameter.");
        }
        Preconditions.checkNotNull((Object)identifier);
        InstanceIdentifierContext iiWithData = payload.getInstanceIdentifierContext();
        RestconfImpl.validateInput(iiWithData.getSchemaNode(), payload);
        RestconfImpl.validateTopLevelNodeName(payload, iiWithData.getInstanceIdentifier());
        RestconfImpl.validateListKeysEqualityInPayloadAndUri(payload);
        DOMMountPoint mountPoint = iiWithData.getMountPoint();
        YangInstanceIdentifier normalizedII = iiWithData.getInstanceIdentifier();
        PutResult result = null;
        int tries = 2;
        while (true) {
            result = mountPoint != null ? this.broker.commitMountPointDataPut(mountPoint, normalizedII, payload.getData(), insert, point) : this.broker.commitConfigurationDataPut(this.controllerContext.getGlobalSchema(), normalizedII, payload.getData(), insert, point);
            try {
                result.getFutureOfPutData().get();
            }
            catch (InterruptedException e) {
                LOG.debug("Update failed for {}", (Object)identifier, (Object)e);
                throw new RestconfDocumentedException(e.getMessage(), (Throwable)e);
            }
            catch (ExecutionException e) {
                TransactionCommitFailedException failure = (TransactionCommitFailedException)Throwables.getCauseAs((Throwable)e, TransactionCommitFailedException.class);
                if (failure instanceof OptimisticLockFailedException) {
                    if (--tries <= 0) {
                        LOG.debug("Got OptimisticLockFailedException on last try - failing {}", (Object)identifier);
                        throw new RestconfDocumentedException(e.getMessage(), (Throwable)e, (Collection)failure.getErrorList());
                    }
                    LOG.debug("Got OptimisticLockFailedException - trying again {}", (Object)identifier);
                    continue;
                }
                LOG.debug("Update failed for {}", (Object)identifier, (Object)e);
                throw RestconfDocumentedException.decodeAndThrow((String)e.getMessage(), (OperationFailedException)failure);
            }
            break;
        }
        return Response.status((Response.Status)result.getStatus()).build();
    }

    private static void validateTopLevelNodeName(NormalizedNodeContext node, YangInstanceIdentifier identifier) {
        String payloadName = node.getData().getNodeType().getLocalName();
        if (identifier.isEmpty()) {
            if (!node.getData().getNodeType().equals((Object)NETCONF_BASE_QNAME)) {
                throw new RestconfDocumentedException("Instance identifier has to contain at least one path argument", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
            }
        } else {
            String identifierName = identifier.getLastPathArgument().getNodeType().getLocalName();
            if (!payloadName.equals(identifierName)) {
                throw new RestconfDocumentedException("Payload name (" + payloadName + ") is different from identifier name (" + identifierName + ")", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
            }
        }
    }

    private static void validateListKeysEqualityInPayloadAndUri(NormalizedNodeContext payload) {
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0);
        InstanceIdentifierContext iiWithData = payload.getInstanceIdentifierContext();
        YangInstanceIdentifier.PathArgument lastPathArgument = iiWithData.getInstanceIdentifier().getLastPathArgument();
        SchemaNode schemaNode = iiWithData.getSchemaNode();
        NormalizedNode data = payload.getData();
        if (schemaNode instanceof ListSchemaNode) {
            List keyDefinitions = ((ListSchemaNode)schemaNode).getKeyDefinition();
            if (lastPathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates && data instanceof MapEntryNode) {
                Map uriKeyValues = ((YangInstanceIdentifier.NodeIdentifierWithPredicates)lastPathArgument).getKeyValues();
                RestconfImpl.isEqualUriAndPayloadKeyValues(uriKeyValues, (MapEntryNode)data, keyDefinitions);
            }
        }
    }

    @VisibleForTesting
    public static void isEqualUriAndPayloadKeyValues(Map<QName, Object> uriKeyValues, MapEntryNode payload, List<QName> keyDefinitions) {
        HashMap mutableCopyUriKeyValues = Maps.newHashMap(uriKeyValues);
        for (QName keyDefinition : keyDefinitions) {
            Object uriKeyValue = mutableCopyUriKeyValues.remove(keyDefinition);
            RestconfValidationUtils.checkDocumentedError((uriKeyValue != null ? 1 : 0) != 0, (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.DATA_MISSING, (String)("Missing key " + keyDefinition + " in URI."));
            Object dataKeyValue = payload.getIdentifier().getKeyValues().get(keyDefinition);
            if (Objects.deepEquals(uriKeyValue, dataKeyValue)) continue;
            String errMsg = "The value '" + uriKeyValue + "' for key '" + keyDefinition.getLocalName() + "' specified in the URI doesn't match the value '" + dataKeyValue + "' specified in the message body. ";
            throw new RestconfDocumentedException(errMsg, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
    }

    @Override
    public Response createConfigurationData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.createConfigurationData(payload, uriInfo);
    }

    @Override
    public Response createConfigurationData(NormalizedNodeContext payload, UriInfo uriInfo) {
        if (payload == null) {
            throw new RestconfDocumentedException("Input is required.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        DOMMountPoint mountPoint = payload.getInstanceIdentifierContext().getMountPoint();
        InstanceIdentifierContext iiWithData = payload.getInstanceIdentifierContext();
        YangInstanceIdentifier normalizedII = iiWithData.getInstanceIdentifier();
        boolean insertUsed = false;
        boolean pointUsed = false;
        String insert = null;
        String point = null;
        if (uriInfo != null) {
            block11: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "insert": {
                        if (!insertUsed) {
                            insertUsed = true;
                            insert = (String)((List)entry.getValue()).iterator().next();
                            continue block11;
                        }
                        throw new RestconfDocumentedException("Insert parameter can be used only once.");
                    }
                    case "point": {
                        if (!pointUsed) {
                            pointUsed = true;
                            point = (String)((List)entry.getValue()).iterator().next();
                            continue block11;
                        }
                        throw new RestconfDocumentedException("Point parameter can be used only once.");
                    }
                }
                throw new RestconfDocumentedException("Bad parameter for post: " + (String)entry.getKey());
            }
        }
        if (pointUsed && !insertUsed) {
            throw new RestconfDocumentedException("Point parameter can't be used without Insert parameter.");
        }
        if (pointUsed && (insert.equals("first") || insert.equals("last"))) {
            throw new RestconfDocumentedException("Point parameter can be used only with 'after' or 'before' values of Insert parameter.");
        }
        FluentFuture<? extends CommitInfo> future = mountPoint != null ? this.broker.commitConfigurationDataPost(mountPoint, normalizedII, payload.getData(), insert, point) : this.broker.commitConfigurationDataPost(this.controllerContext.getGlobalSchema(), normalizedII, payload.getData(), insert, point);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOG.info("Error creating data {}", (Object)(uriInfo != null ? uriInfo.getPath() : ""), (Object)e);
            throw new RestconfDocumentedException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.info("Error creating data {}", (Object)(uriInfo != null ? uriInfo.getPath() : ""), (Object)e);
            throw RestconfDocumentedException.decodeAndThrow((String)e.getMessage(), (OperationFailedException)((OperationFailedException)Throwables.getCauseAs((Throwable)e, TransactionCommitFailedException.class)));
        }
        LOG.trace("Successfuly created data.");
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.NO_CONTENT);
        URI location = this.resolveLocation(uriInfo, "", mountPoint, normalizedII);
        if (location != null) {
            responseBuilder.location(location);
        }
        return responseBuilder.build();
    }

    private URI resolveLocation(UriInfo uriInfo, String uriBehindBase, DOMMountPoint mountPoint, YangInstanceIdentifier normalizedII) {
        if (uriInfo == null) {
            return null;
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("config");
        try {
            uriBuilder.path(this.controllerContext.toFullRestconfIdentifier(normalizedII, mountPoint));
        }
        catch (Exception e) {
            LOG.info("Location for instance identifier {} was not created", (Object)normalizedII, (Object)e);
            return null;
        }
        return uriBuilder.build(new Object[0]);
    }

    @Override
    public Response deleteConfigurationData(String identifier) {
        InstanceIdentifierContext<?> iiWithData = this.controllerContext.toInstanceIdentifier(identifier);
        DOMMountPoint mountPoint = iiWithData.getMountPoint();
        YangInstanceIdentifier normalizedII = iiWithData.getInstanceIdentifier();
        FluentFuture<? extends CommitInfo> future = mountPoint != null ? this.broker.commitConfigurationDataDelete(mountPoint, normalizedII) : this.broker.commitConfigurationDataDelete(normalizedII);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new RestconfDocumentedException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Optional searchedException = Iterables.tryFind((Iterable)Throwables.getCausalChain((Throwable)e), (Predicate)Predicates.instanceOf(ModifiedNodeDoesNotExistException.class)).toJavaUtil();
            if (searchedException.isPresent()) {
                throw new RestconfDocumentedException("Data specified for delete doesn't exist.", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.DATA_MISSING, (Throwable)e);
            }
            throw RestconfDocumentedException.decodeAndThrow((String)e.getMessage(), (OperationFailedException)((OperationFailedException)Throwables.getCauseAs((Throwable)e, TransactionCommitFailedException.class)));
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public NormalizedNodeContext subscribeToStream(String identifier, UriInfo uriInfo) {
        boolean startTimeUsed = false;
        boolean stopTimeUsed = false;
        Instant start = Instant.now();
        Instant stop = null;
        boolean filterUsed = false;
        String filter = null;
        boolean leafNodesOnlyUsed = false;
        boolean leafNodesOnly = false;
        block12: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            switch ((String)entry.getKey()) {
                case "start-time": {
                    if (!startTimeUsed) {
                        startTimeUsed = true;
                        start = RestconfImpl.parseDateFromQueryParam(entry);
                        continue block12;
                    }
                    throw new RestconfDocumentedException("Start-time parameter can be used only once.");
                }
                case "stop-time": {
                    if (!stopTimeUsed) {
                        stopTimeUsed = true;
                        stop = RestconfImpl.parseDateFromQueryParam(entry);
                        continue block12;
                    }
                    throw new RestconfDocumentedException("Stop-time parameter can be used only once.");
                }
                case "filter": {
                    if (!filterUsed) {
                        filterUsed = true;
                        filter = (String)((List)entry.getValue()).iterator().next();
                        continue block12;
                    }
                    throw new RestconfDocumentedException("Filter parameter can be used only once.");
                }
                case "odl-leaf-nodes-only": {
                    if (!leafNodesOnlyUsed) {
                        leafNodesOnlyUsed = true;
                        leafNodesOnly = Boolean.parseBoolean((String)((List)entry.getValue()).iterator().next());
                        continue block12;
                    }
                    throw new RestconfDocumentedException("Odl-leaf-nodes-only parameter can be used only once.");
                }
            }
            throw new RestconfDocumentedException("Bad parameter used with notifications: " + (String)entry.getKey());
        }
        if (!startTimeUsed && stopTimeUsed) {
            throw new RestconfDocumentedException("Stop-time parameter has to be used with start-time parameter.");
        }
        URI response = null;
        if (identifier.contains(DATA_SUBSCR)) {
            response = this.dataSubs(identifier, uriInfo, start, stop, filter, leafNodesOnly);
        } else if (identifier.contains(NOTIFICATION_STREAM)) {
            response = this.notifStream(identifier, uriInfo, start, stop, filter);
        }
        if (response != null) {
            InstanceIdentifierContext<?> iid = this.prepareIIDSubsStreamOutput();
            NormalizedNodeAttrBuilder builder = ImmutableLeafNodeBuilder.create().withValue((Object)response.toString());
            builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((String)"subscribe:to:notification", (String)"2016-10-28", (String)"location")));
            HashMap<String, URI> headers = new HashMap<String, URI>();
            headers.put("Location", response);
            return new NormalizedNodeContext(iid, builder.build(), headers);
        }
        String msg = "Bad type of notification of sal-remote";
        LOG.warn("Bad type of notification of sal-remote");
        throw new RestconfDocumentedException("Bad type of notification of sal-remote");
    }

    private static Instant parseDateFromQueryParam(Map.Entry<String, List<String>> entry) {
        TemporalAccessor p;
        DateAndTime event = new DateAndTime(entry.getValue().iterator().next());
        String value = event.getValue();
        try {
            p = FORMATTER.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new RestconfDocumentedException("Cannot parse of value in date: " + value, (Throwable)e);
        }
        return Instant.from(p);
    }

    private InstanceIdentifierContext<?> prepareIIDSubsStreamOutput() {
        QName qnameBase = QName.create((String)"subscribe:to:notification", (String)"2016-10-28", (String)"notifi");
        SchemaContext schemaCtx = this.controllerContext.getGlobalSchema();
        DataSchemaNode location = ((ContainerSchemaNode)((Module)schemaCtx.findModule(qnameBase.getModule()).orElse(null)).getDataChildByName(qnameBase)).getDataChildByName(QName.create((QName)qnameBase, (String)"location"));
        ArrayList<YangInstanceIdentifier.NodeIdentifier> path = new ArrayList<YangInstanceIdentifier.NodeIdentifier>();
        path.add(YangInstanceIdentifier.NodeIdentifier.create((QName)qnameBase));
        path.add(YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)qnameBase, (String)"location")));
        return new InstanceIdentifierContext(YangInstanceIdentifier.create(path), (SchemaNode)location, null, schemaCtx);
    }

    private URI notifStream(String identifier, UriInfo uriInfo, Instant start, Instant stop, String filter) {
        String streamName = Notificator.createStreamNameFromUri(identifier);
        if (Strings.isNullOrEmpty((String)streamName)) {
            throw new RestconfDocumentedException("Stream name is empty.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        List<NotificationListenerAdapter> listeners = Notificator.getNotificationListenerFor(streamName);
        if (listeners == null || listeners.isEmpty()) {
            throw new RestconfDocumentedException("Stream was not found.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
        }
        for (NotificationListenerAdapter listener : listeners) {
            this.broker.registerToListenNotification(listener);
            listener.setQueryParams(start, (Optional)Optional.ofNullable(stop), (Optional)Optional.ofNullable(filter), false);
        }
        UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
        WebSocketServer webSocketServerInstance = WebSocketServer.getInstance(8181);
        int notificationPort = webSocketServerInstance.getPort();
        UriBuilder uriToWebsocketServerBuilder = uriBuilder.port(notificationPort).scheme(RestconfImpl.getWsScheme(uriInfo));
        return uriToWebsocketServerBuilder.replacePath(streamName).build(new Object[0]);
    }

    private static String getWsScheme(UriInfo uriInfo) {
        URI uri = uriInfo.getAbsolutePath();
        if (uri == null) {
            return "ws";
        }
        String subscriptionScheme = uri.getScheme().toLowerCase(Locale.ROOT);
        return subscriptionScheme.equals("https") ? "wss" : "ws";
    }

    private URI dataSubs(String identifier, UriInfo uriInfo, Instant start, Instant stop, String filter, boolean leafNodesOnly) {
        String streamName = Notificator.createStreamNameFromUri(identifier);
        if (Strings.isNullOrEmpty((String)streamName)) {
            throw new RestconfDocumentedException("Stream name is empty.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        ListenerAdapter listener = Notificator.getListenerFor(streamName);
        if (listener == null) {
            throw new RestconfDocumentedException("Stream was not found.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
        }
        listener.setQueryParams(start, (Optional)Optional.ofNullable(stop), (Optional)Optional.ofNullable(filter), leafNodesOnly);
        Map<String, String> paramToValues = RestconfImpl.resolveValuesFromUri(identifier);
        LogicalDatastoreType datastore = RestconfImpl.parserURIEnumParameter(LogicalDatastoreType.class, paramToValues.get(DATASTORE_PARAM_NAME));
        if (datastore == null) {
            throw new RestconfDocumentedException("Stream name doesn't contains datastore value (pattern /datastore=)", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.MISSING_ATTRIBUTE);
        }
        DataChangeScope scope = RestconfImpl.parserURIEnumParameter(DataChangeScope.class, paramToValues.get(SCOPE_PARAM_NAME));
        if (scope == null) {
            throw new RestconfDocumentedException("Stream name doesn't contains datastore value (pattern /scope=)", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.MISSING_ATTRIBUTE);
        }
        this.broker.registerToListenDataChanges(datastore, scope, listener);
        UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
        WebSocketServer webSocketServerInstance = WebSocketServer.getInstance(8181);
        int notificationPort = webSocketServerInstance.getPort();
        UriBuilder uriToWebsocketServerBuilder = uriBuilder.port(notificationPort).scheme(RestconfImpl.getWsScheme(uriInfo));
        return uriToWebsocketServerBuilder.replacePath(streamName).build(new Object[0]);
    }

    @Override
    public PatchStatusContext patchConfigurationData(String identifier, PatchContext context, UriInfo uriInfo) {
        if (context == null) {
            throw new RestconfDocumentedException("Input is required.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        try {
            return this.broker.patchConfigurationDataWithinTransaction(context);
        }
        catch (Exception e) {
            LOG.debug("Patch transaction failed", (Throwable)e);
            throw new RestconfDocumentedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PatchStatusContext patchConfigurationData(PatchContext context, @Context UriInfo uriInfo) {
        if (context == null) {
            throw new RestconfDocumentedException("Input is required.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        try {
            return this.broker.patchConfigurationDataWithinTransaction(context);
        }
        catch (Exception e) {
            LOG.debug("Patch transaction failed", (Throwable)e);
            throw new RestconfDocumentedException(e.getMessage(), (Throwable)e);
        }
    }

    private static <T> T parseEnumTypeParameter(ContainerNode value, Class<T> classDescriptor, String paramName) {
        Optional optAugNode = value.getChild((YangInstanceIdentifier.PathArgument)SAL_REMOTE_AUG_IDENTIFIER);
        if (!optAugNode.isPresent()) {
            return null;
        }
        DataContainerChild augNode = (DataContainerChild)optAugNode.get();
        if (!(augNode instanceof AugmentationNode)) {
            return null;
        }
        Optional enumNode = ((AugmentationNode)augNode).getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((QNameModule)SAL_REMOTE_AUGMENT, (String)paramName)));
        if (!enumNode.isPresent()) {
            return null;
        }
        Object rawValue = ((DataContainerChild)enumNode.get()).getValue();
        if (!(rawValue instanceof String)) {
            return null;
        }
        return RestconfImpl.resolveAsEnum(classDescriptor, (String)rawValue);
    }

    private static <T> T parserURIEnumParameter(Class<T> classDescriptor, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return RestconfImpl.resolveAsEnum(classDescriptor, value);
    }

    private static <T> T resolveAsEnum(Class<T> classDescriptor, String value) {
        T[] enumConstants = classDescriptor.getEnumConstants();
        if (enumConstants != null) {
            for (T enm : classDescriptor.getEnumConstants()) {
                if (!((Enum)enm).name().equals(value)) continue;
                return enm;
            }
        }
        return null;
    }

    private static Map<String, String> resolveValuesFromUri(String uri) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] tokens = uri.split("/");
        for (int i = 1; i < tokens.length; ++i) {
            String[] parameterTokens = tokens[i].split("=");
            if (parameterTokens.length != 2) continue;
            result.put(parameterTokens[0], parameterTokens[1]);
        }
        return result;
    }

    private MapNode makeModuleMapNode(Set<Module> modules) {
        Preconditions.checkNotNull(modules);
        Module restconfModule = this.getRestconfModule();
        DataSchemaNode moduleSchemaNode = this.controllerContext.getRestconfModuleRestConfSchemaNode(restconfModule, "module");
        Preconditions.checkState((boolean)(moduleSchemaNode instanceof ListSchemaNode));
        CollectionNodeBuilder listModuleBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)moduleSchemaNode));
        for (Module module : modules) {
            listModuleBuilder.withChild((NormalizedNode)this.toModuleEntryNode(module, moduleSchemaNode));
        }
        return (MapNode)listModuleBuilder.build();
    }

    private MapEntryNode toModuleEntryNode(Module module, DataSchemaNode moduleSchemaNode) {
        Preconditions.checkArgument((boolean)(moduleSchemaNode instanceof ListSchemaNode), (Object)"moduleSchemaNode has to be of type ListSchemaNode");
        ListSchemaNode listModuleSchemaNode = (ListSchemaNode)moduleSchemaNode;
        DataContainerNodeAttrBuilder moduleNodeValues = Builders.mapEntryBuilder((ListSchemaNode)listModuleSchemaNode);
        List<DataSchemaNode> instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listModuleSchemaNode, "name");
        DataSchemaNode nameSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(nameSchemaNode instanceof LeafSchemaNode));
        moduleNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)nameSchemaNode)).withValue((Object)module.getName()).build());
        QNameModule qNameModule = module.getQNameModule();
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listModuleSchemaNode, "revision");
        DataSchemaNode revisionSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(revisionSchemaNode instanceof LeafSchemaNode));
        Optional revision = qNameModule.getRevision();
        moduleNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)revisionSchemaNode)).withValue((Object)revision.map(Revision::toString).orElse("")).build());
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listModuleSchemaNode, "namespace");
        DataSchemaNode namespaceSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(namespaceSchemaNode instanceof LeafSchemaNode));
        moduleNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)namespaceSchemaNode)).withValue((Object)qNameModule.getNamespace().toString()).build());
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listModuleSchemaNode, "feature");
        DataSchemaNode featureSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(featureSchemaNode instanceof LeafListSchemaNode));
        ListNodeBuilder featuresBuilder = Builders.leafSetBuilder((LeafListSchemaNode)((LeafListSchemaNode)featureSchemaNode));
        for (FeatureDefinition feature : module.getFeatures()) {
            featuresBuilder.withChild((LeafSetEntryNode)Builders.leafSetEntryBuilder((LeafListSchemaNode)((LeafListSchemaNode)featureSchemaNode)).withValue((Object)feature.getQName().getLocalName()).build());
        }
        moduleNodeValues.withChild((DataContainerChild)featuresBuilder.build());
        return (MapEntryNode)moduleNodeValues.build();
    }

    protected MapEntryNode toStreamEntryNode(String streamName, DataSchemaNode streamSchemaNode) {
        Preconditions.checkArgument((boolean)(streamSchemaNode instanceof ListSchemaNode), (Object)"streamSchemaNode has to be of type ListSchemaNode");
        ListSchemaNode listStreamSchemaNode = (ListSchemaNode)streamSchemaNode;
        DataContainerNodeAttrBuilder streamNodeValues = Builders.mapEntryBuilder((ListSchemaNode)listStreamSchemaNode);
        List<DataSchemaNode> instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "name");
        DataSchemaNode nameSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(nameSchemaNode instanceof LeafSchemaNode));
        streamNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)nameSchemaNode)).withValue((Object)streamName).build());
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "description");
        DataSchemaNode descriptionSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(descriptionSchemaNode instanceof LeafSchemaNode));
        streamNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)nameSchemaNode)).withValue((Object)"DESCRIPTION_PLACEHOLDER").build());
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "replay-support");
        DataSchemaNode replaySupportSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(replaySupportSchemaNode instanceof LeafSchemaNode));
        streamNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)replaySupportSchemaNode)).withValue((Object)Boolean.TRUE).build());
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "replay-log-creation-time");
        DataSchemaNode replayLogCreationTimeSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(replayLogCreationTimeSchemaNode instanceof LeafSchemaNode));
        streamNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)replayLogCreationTimeSchemaNode)).withValue((Object)"").build());
        instanceDataChildrenByName = ControllerContext.findInstanceDataChildrenByName((DataNodeContainer)listStreamSchemaNode, "events");
        DataSchemaNode eventsSchemaNode = (DataSchemaNode)Iterables.getFirst(instanceDataChildrenByName, null);
        Preconditions.checkState((boolean)(eventsSchemaNode instanceof LeafSchemaNode));
        streamNodeValues.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)eventsSchemaNode)).build());
        return (MapEntryNode)streamNodeValues.build();
    }

    private ListenableFuture<DOMRpcResult> invokeSalRemoteRpcNotifiStrRPC(NormalizedNodeContext payload) {
        ContainerNode data = (ContainerNode)payload.getData();
        LeafSetNode leafSet = null;
        String outputType = "XML";
        for (DataContainerChild dataChild : data.getValue()) {
            if (dataChild instanceof LeafSetNode) {
                leafSet = (LeafSetNode)dataChild;
                continue;
            }
            if (!(dataChild instanceof AugmentationNode)) continue;
            outputType = (String)((DataContainerChild)((AugmentationNode)dataChild).getValue().iterator().next()).getValue();
        }
        Collection entryNodes = leafSet.getValue();
        ArrayList<SchemaPath> paths = new ArrayList<SchemaPath>();
        String streamName = CREATE_NOTIFICATION_STREAM + "/";
        StringBuilder streamNameBuilder = new StringBuilder(streamName);
        Iterator iterator = entryNodes.iterator();
        while (iterator.hasNext()) {
            QName valueQName = QName.create((String)((String)((LeafSetEntryNode)iterator.next()).getValue()));
            Module module = this.controllerContext.findModuleByNamespace(valueQName.getModule().getNamespace());
            Preconditions.checkNotNull((Object)module, (Object)("Module for namespace " + valueQName.getModule().getNamespace() + " does not exist"));
            NotificationDefinition notifiDef = null;
            for (NotificationDefinition notification : module.getNotifications()) {
                if (!notification.getQName().equals((Object)valueQName)) continue;
                notifiDef = notification;
                break;
            }
            String moduleName = module.getName();
            Preconditions.checkNotNull((Object)notifiDef, (Object)("Notification " + valueQName + "doesn't exist in module " + moduleName));
            paths.add(notifiDef.getPath());
            streamNameBuilder.append(moduleName).append(':').append(valueQName.getLocalName());
            if (!iterator.hasNext()) continue;
            streamNameBuilder.append(',');
        }
        streamName = streamNameBuilder.toString();
        QName rpcQName = payload.getInstanceIdentifierContext().getSchemaNode().getQName();
        QName outputQname = QName.create((QName)rpcQName, (String)"output");
        QName streamNameQname = QName.create((QName)rpcQName, (String)"notification-stream-identifier");
        ContainerNode output = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(outputQname)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)streamNameQname, (Object)streamName)).build();
        if (!Notificator.existNotificationListenerFor(streamName)) {
            Notificator.createNotificationListener(paths, streamName, outputType, this.controllerContext);
        }
        return Futures.immediateFuture((Object)new DefaultDOMRpcResult((NormalizedNode)output));
    }
}

