/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.netconf.sal.rest.api.RestConnector;
import org.opendaylight.netconf.sal.restconf.impl.StatisticsRestconfServiceWrapper;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Config;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Delete;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Get;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Operational;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Post;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Put;
import org.opendaylight.netconf.sal.restconf.impl.jmx.RestConnectorRuntimeMXBean;
import org.opendaylight.netconf.sal.restconf.impl.jmx.Rpcs;
import org.opendaylight.netconf.sal.streams.websockets.WebSocketServer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;

public class RestconfProviderImpl
extends AbstractMXBean
implements AutoCloseable,
RestConnector,
RestConnectorRuntimeMXBean {
    private final IpAddress websocketAddress;
    private final PortNumber websocketPort;
    private final StatisticsRestconfServiceWrapper stats;
    private Thread webSocketServerThread;

    public RestconfProviderImpl(StatisticsRestconfServiceWrapper stats, IpAddress websocketAddress, PortNumber websocketPort) {
        super("Draft02ProviderStatistics", "restconf-connector", null);
        this.stats = (StatisticsRestconfServiceWrapper)Preconditions.checkNotNull((Object)stats);
        this.websocketAddress = (IpAddress)Preconditions.checkNotNull((Object)websocketAddress);
        this.websocketPort = (PortNumber)Preconditions.checkNotNull((Object)websocketPort);
    }

    public void start() {
        this.webSocketServerThread = new Thread(WebSocketServer.createInstance(this.websocketAddress.stringValue(), this.websocketPort.getValue()));
        this.webSocketServerThread.setName("Web socket server on port " + this.websocketPort);
        this.webSocketServerThread.start();
        this.registerMBean();
    }

    @Override
    public void close() {
        WebSocketServer.destroyInstance();
        if (this.webSocketServerThread != null) {
            this.webSocketServerThread.interrupt();
        }
        this.unregisterMBean();
    }

    @Override
    public Config getConfig() {
        Config config = new Config();
        Get get = new Get();
        get.setReceivedRequests(this.stats.getConfigGet());
        get.setSuccessfulResponses(this.stats.getSuccessGetConfig());
        get.setFailedResponses(this.stats.getFailureGetConfig());
        config.setGet(get);
        Post post = new Post();
        post.setReceivedRequests(this.stats.getConfigPost());
        post.setSuccessfulResponses(this.stats.getSuccessPost());
        post.setFailedResponses(this.stats.getFailurePost());
        config.setPost(post);
        Put put = new Put();
        put.setReceivedRequests(this.stats.getConfigPut());
        put.setSuccessfulResponses(this.stats.getSuccessPut());
        put.setFailedResponses(this.stats.getFailurePut());
        config.setPut(put);
        Delete delete = new Delete();
        delete.setReceivedRequests(this.stats.getConfigDelete());
        delete.setSuccessfulResponses(this.stats.getSuccessDelete());
        delete.setFailedResponses(this.stats.getFailureDelete());
        config.setDelete(delete);
        return config;
    }

    @Override
    public Operational getOperational() {
        BigInteger opGet = this.stats.getOperationalGet();
        Operational operational = new Operational();
        Get get = new Get();
        get.setReceivedRequests(opGet);
        get.setSuccessfulResponses(this.stats.getSuccessGetOperational());
        get.setFailedResponses(this.stats.getFailureGetOperational());
        operational.setGet(get);
        return operational;
    }

    @Override
    public Rpcs getRpcs() {
        BigInteger rpcInvoke = this.stats.getRpc();
        Rpcs rpcs = new Rpcs();
        rpcs.setReceivedRequests(rpcInvoke);
        return rpcs;
    }
}

