/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.streams.listeners;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class AbstractNotificationsData {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNotificationsData.class);
    private static final TransformerFactory TF = TransformerFactory.newInstance();
    private static final XMLOutputFactory OF = XMLOutputFactory.newFactory();

    AbstractNotificationsData() {
    }

    protected static String toRFC3339(Instant now) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(now, ZoneId.systemDefault()));
    }

    protected static Document createDocument() {
        return UntrustedXML.newDocumentBuilder().newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DOMResult writeNormalizedNode(NormalizedNode<?, ?> normalized, SchemaContext context, SchemaPath schemaPath) throws IOException, XMLStreamException {
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        DOMResult result = new DOMResult(doc);
        NormalizedNodeWriter normalizedNodeWriter = null;
        NormalizedNodeStreamWriter normalizedNodeStreamWriter = null;
        XMLStreamWriter writer = null;
        try {
            writer = OF.createXMLStreamWriter(result);
            normalizedNodeStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)writer, (SchemaContext)context, (SchemaPath)schemaPath);
            normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)normalizedNodeStreamWriter);
            normalizedNodeWriter.write(normalized);
            normalizedNodeWriter.flush();
        }
        finally {
            if (normalizedNodeWriter != null) {
                normalizedNodeWriter.close();
            }
            if (normalizedNodeStreamWriter != null) {
                normalizedNodeStreamWriter.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return result;
    }

    protected Element basePartDoc(Document doc) {
        Element notificationElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:notification:1.0", "notification");
        doc.appendChild(notificationElement);
        Element eventTimeElement = doc.createElement("eventTime");
        eventTimeElement.setTextContent(AbstractNotificationsData.toRFC3339(Instant.now()));
        notificationElement.appendChild(eventTimeElement);
        return notificationElement;
    }

    protected String transformDoc(Document doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Transformer transformer = TF.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            String msg = "Error during transformation of Document into String";
            LOG.error("Error during transformation of Document into String", (Throwable)e);
            return "Error during transformation of Document into String";
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }
}

