/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cli.SessionsManager;
import org.opendaylight.aaa.cli.utils.CliUtils;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public abstract class AaaCliAbstractCommand
implements Action {
    private static volatile String authUser = null;
    @Reference
    protected IIDMStore identityStore;
    @Reference
    private PasswordHashService passwordService;

    public Object execute() throws Exception {
        User currentUser = SessionsManager.getInstance().getCurrentUser(authUser);
        if (currentUser == null) {
            String passwd;
            String userName = CliUtils.readPassword("Enter Username:");
            User usr = DataStoreUtils.isAdminUser(this.identityStore, this.passwordService, userName, passwd = CliUtils.readPassword("Enter Password:"));
            if (usr != null) {
                authUser = userName;
                SessionsManager.getInstance().addUserSession(userName, usr);
            }
            return usr;
        }
        return currentUser;
    }

    protected void list(String name, Collection<?> items) {
        System.out.println(name);
        items.forEach(i -> System.out.println("  " + i));
    }
}

