/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.aaa.api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionsManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SessionsManager.class);
    private static SessionsManager sessionMgr = new SessionsManager();
    private final Cache authUsers;
    private static final int MAX_CACHED_USERS_IN_MEMORY = 1;
    private static final int MAX_CACHED_USERS_ON_DISK = 1;
    private static final long SECONDS_TO_LIVE = 120L;
    private static final long SECONDS_TO_IDLE = 60L;
    private static final String CLI_CACHE_MANAGER = "org.opendaylight.aaa.cli";
    private static final String CLI_CACHE = "users";

    private SessionsManager() {
        Cache existingCache;
        CacheManager cm = CacheManager.getCacheManager((String)CLI_CACHE_MANAGER);
        if (cm == null) {
            Configuration configuration = ConfigurationFactory.parseConfiguration();
            configuration.setName(CLI_CACHE_MANAGER);
            cm = CacheManager.newInstance();
        }
        if ((existingCache = cm.getCache(CLI_CACHE)) != null) {
            this.authUsers = existingCache;
        } else {
            this.authUsers = new Cache(new CacheConfiguration(CLI_CACHE, 1).maxEntriesLocalDisk(1).timeToLiveSeconds(120L).timeToIdleSeconds(60L));
            cm.addCache(this.authUsers);
        }
        LOG.info("Initialized cli authorized users cache manager");
    }

    public static SessionsManager getInstance() {
        return sessionMgr;
    }

    @Override
    public void close() {
        LOG.info("Shutting down cli authorized users cache manager");
        CacheManager.getInstance().shutdown();
    }

    public void addUserSession(String userName, User usr) {
        this.authUsers.put(new Element((Object)userName, (Object)usr));
    }

    public @Nullable User getCurrentUser(String userName) {
        Element elem = this.authUsers.get((Serializable)((Object)userName));
        if (elem != null) {
            return (User)elem.getObjectValue();
        }
        return null;
    }
}

