/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="add-grant", scope="aaa", description="Add Grant.")
public class AddGrant
extends AaaCliAbstractCommand {
    @Option(name="-uname", aliases={"--userName"}, description="The user name", required=true, multiValued=false)
    private String userName;
    @Option(name="-dname", aliases={"--domainName"}, description="The domain name", required=true, multiValued=false)
    private String domainName;
    @Option(name="-rname", aliases={"--roleName"}, description="The role name", required=false, multiValued=false)
    private String roleName;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        String domainId = DataStoreUtils.getDomainId(this.identityStore, this.domainName);
        if (domainId == null) {
            return "Domain does not exist";
        }
        String roleId = DataStoreUtils.getRoleId(this.identityStore, this.roleName);
        if (roleId == null) {
            return "Role does not exist";
        }
        String usrId = DataStoreUtils.getUserId(this.identityStore, this.userName);
        if (usrId == null) {
            return "User does not exist";
        }
        Grant grant = new Grant();
        grant.setDomainid(domainId);
        grant.setRoleid(roleId);
        grant.setUserid(usrId);
        grant = this.identityStore.writeGrant(grant);
        if (grant != null) {
            return "Grant has been created, Grant id is " + grant.getGrantid();
        }
        return null;
    }
}

