/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="remove-domain", scope="aaa", description="Remove domain.")
public class RemoveDomain
extends AaaCliAbstractCommand {
    @Reference
    private ClaimCache claimCache;
    @Option(name="-name", aliases={"--domainName"}, description="The domain name", required=true, multiValued=false)
    private String domainName;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        String domainId = DataStoreUtils.getDomainId(this.identityStore, this.domainName);
        if (domainId == null) {
            return "User does not exist";
        }
        if (this.identityStore.deleteDomain(domainId) == null) {
            return "Failed to delete domain " + this.domainName;
        }
        this.claimCache.clear();
        return "Domain " + this.domainName + "has been deleted.";
    }
}

