/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="remove-grant", scope="aaa", description="Remove grant.")
public class RemoveGrant
extends AaaCliAbstractCommand {
    @Reference
    private ClaimCache claimCache;
    @Option(name="-uname", aliases={"--userName"}, description="The user name", required=true, multiValued=false)
    private String userName;
    @Option(name="-dname", aliases={"--domainName"}, description="The domain name", required=true, multiValued=false)
    private String domainName;
    @Option(name="-rname", aliases={"--roleName"}, description="The role name", required=false, multiValued=false)
    private String roleName;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        String grantid = DataStoreUtils.getGrantId(this.identityStore, this.domainName, this.roleName, this.userName);
        if (grantid == null) {
            return "Grant does not exist";
        }
        if (this.identityStore.deleteGrant(grantid) == null) {
            return "Failed to delete grant " + this.userName + " " + this.roleName + " " + this.domainName;
        }
        this.claimCache.clear();
        return "Grant has been deleted.";
    }
}

