/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="remove-role", scope="aaa", description="Remove role.")
public class RemoveRole
extends AaaCliAbstractCommand {
    @Reference
    private ClaimCache claimCache;
    @Option(name="-name", aliases={"--roleName"}, description="The role name", required=true, multiValued=false)
    private String roleName;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        String roleId = DataStoreUtils.getRoleId(this.identityStore, this.roleName);
        if (roleId == null) {
            return "Role does not exist";
        }
        if (this.identityStore.deleteRole(roleId) == null) {
            return "Failed to delete role " + this.roleName;
        }
        this.claimCache.clear();
        return "Role " + this.roleName + "has been deleted.";
    }
}

