/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.dmstore;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.cli.AaaCliAbstractCommand;
import org.opendaylight.aaa.cli.utils.DataStoreUtils;

@Service
@Command(name="remove-user", scope="aaa", description="Remove user.")
public class RemoveUser
extends AaaCliAbstractCommand {
    @Reference
    private ClaimCache claimCache;
    @Option(name="-name", aliases={"--userName"}, description="The user name", required=true, multiValued=false)
    private String userName;

    @Override
    public Object execute() throws Exception {
        if (super.execute() == null) {
            return "User does not exist OR user name and passsword are not correct";
        }
        String usrId = DataStoreUtils.getUserId(this.identityStore, this.userName);
        if (usrId == null) {
            return "User does not exist";
        }
        if (this.identityStore.deleteUser(usrId) == null) {
            return "Failed to delete user " + this.userName;
        }
        this.claimCache.clear();
        return "User " + this.userName + "has been deleted.";
    }
}

