/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.utils;

import java.util.List;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.Domain;
import org.opendaylight.aaa.api.model.Domains;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.Users;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataStoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreUtils.class);
    private static final String ADMIN_ROLE = "admin";

    private DataStoreUtils() {
    }

    public static String getDomainId(IIDMStore identityStore, String domainName) throws IDMStoreException {
        Domains domains = identityStore.getDomains();
        if (domains != null) {
            for (Domain domain : domains.getDomains()) {
                if (!domain.getName().equalsIgnoreCase(domainName)) continue;
                return domain.getDomainid();
            }
        }
        return null;
    }

    public static String getRoleId(IIDMStore identityStore, String roleName) throws IDMStoreException {
        List roles = identityStore.getRoles().getRoles();
        for (Role role : roles) {
            if (!role.getName().equalsIgnoreCase(roleName)) continue;
            return role.getRoleid();
        }
        return null;
    }

    public static String getUserId(IIDMStore identityStore, String userName) throws IDMStoreException {
        List users = identityStore.getUsers().getUsers();
        for (User usr : users) {
            if (!usr.getName().equalsIgnoreCase(userName)) continue;
            return usr.getUserid();
        }
        return null;
    }

    public static String getGrantId(IIDMStore identityStore, String domainName, String roleName, String userName) throws IDMStoreException {
        String domainId = DataStoreUtils.getDomainId(identityStore, domainName);
        if (domainId == null) {
            return null;
        }
        String usrId = DataStoreUtils.getUserId(identityStore, userName);
        if (usrId == null) {
            return null;
        }
        List grants = identityStore.getGrants(usrId).getGrants();
        if (grants == null || grants.isEmpty()) {
            return null;
        }
        String roleId = DataStoreUtils.getRoleId(identityStore, roleName);
        if (roleId == null) {
            return null;
        }
        for (Grant grant : grants) {
            if (!grant.getRoleid().equals(roleId)) continue;
            return grant.getGrantid();
        }
        return null;
    }

    public static User isAdminUser(IIDMStore identityStore, PasswordHashService passwordService, String userName, String password) throws IDMStoreException {
        Users users = identityStore.getUsers();
        for (User usr : users.getUsers()) {
            List grants;
            if (!usr.getName().equals(userName) || !passwordService.passwordsMatch(password, usr.getPassword(), usr.getSalt()) || (grants = identityStore.getGrants(usr.getUserid()).getGrants()) == null || grants.isEmpty()) continue;
            String adminRoleId = DataStoreUtils.getRoleId(identityStore, ADMIN_ROLE);
            for (Grant grant : grants) {
                if (!grant.getRoleid().equals(adminRoleId)) continue;
                return usr;
            }
            LOG.debug("user is not authorized for admin grant");
        }
        return null;
    }
}

