/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogReaderServiceImpl
implements LogReaderService {
    private final List<LogListener> m_listeners = new CopyOnWriteArrayList<LogListener>();
    private final Deque<LogEntry> m_entries;
    private int m_maxEntries;

    public LogReaderServiceImpl(int maxEntries) {
        this.m_maxEntries = maxEntries;
        this.m_entries = new LinkedList<LogEntry>();
    }

    public void addLogListener(LogListener logListener) {
        this.m_listeners.add(logListener);
    }

    public void removeLogListener(LogListener logListener) {
        this.m_listeners.remove(logListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getLog() {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            return Collections.enumeration(new ArrayList<LogEntry>(this.m_entries));
        }
    }

    private void cleanUp() {
        while (this.m_entries.size() > this.m_maxEntries) {
            this.m_entries.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireEvent(LogEntry entry) {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            this.m_entries.addFirst(entry);
            this.cleanUp();
        }
        List<LogListener> listeners = this.m_listeners;
        for (LogListener listener : listeners) {
            this.fire(listener, entry);
        }
    }

    private void fire(LogListener listener, LogEntry entry) {
        try {
            listener.logged(entry);
        }
        catch (Throwable e) {
            StatusLogger.getLogger().error("'{}' is removed as a LogListener since it threw an exception.", (Object)listener, (Object)e);
            this.removeLogListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setMaxEntries(int maxSize) {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            this.m_maxEntries = maxSize;
        }
    }
}

