/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster;

import akka.japi.Procedure;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.UntypedPersistentActor;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.DataPersistenceProvider;

public class PersistentDataProvider
implements DataPersistenceProvider {
    private final UntypedPersistentActor persistentActor;

    public PersistentDataProvider(UntypedPersistentActor persistentActor) {
        this.persistentActor = (UntypedPersistentActor)Preconditions.checkNotNull((Object)persistentActor, (Object)"persistentActor can't be null");
    }

    @Override
    public boolean isRecoveryApplicable() {
        return true;
    }

    @Override
    public <T> void persist(T entry, Procedure<T> procedure) {
        this.persistentActor.persist(entry, procedure);
    }

    @Override
    public <T> void persistAsync(T entry, Procedure<T> procedure) {
        this.persistentActor.persistAsync(entry, procedure);
    }

    @Override
    public void saveSnapshot(Object snapshot) {
        this.persistentActor.saveSnapshot(snapshot);
    }

    @Override
    public void deleteSnapshots(SnapshotSelectionCriteria criteria) {
        this.persistentActor.deleteSnapshots(criteria);
    }

    @Override
    public void deleteMessages(long sequenceNumber) {
        this.persistentActor.deleteMessages(sequenceNumber);
    }

    @Override
    public long getLastSequenceNumber() {
        return this.persistentActor.lastSequenceNr();
    }
}

