/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.ActorRef;
import akka.actor.UntypedActor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.common.actor.ExecuteInSelfActor;
import org.opendaylight.controller.cluster.common.actor.ExecuteInSelfMessage;
import org.opendaylight.controller.cluster.common.actor.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUntypedActor
extends UntypedActor
implements ExecuteInSelfActor {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    protected AbstractUntypedActor() {
        this.LOG.debug("Actor created {}", (Object)this.getSelf());
        this.getContext().system().actorSelection("user/termination-monitor").tell((Object)new Monitor(this.getSelf()), this.getSelf());
    }

    @Override
    public final void executeInSelf(@NonNull Runnable runnable) {
        ExecuteInSelfMessage message = new ExecuteInSelfMessage(runnable);
        this.self().tell((Object)message, ActorRef.noSender());
    }

    public final void onReceive(Object message) {
        if (message instanceof ExecuteInSelfMessage) {
            ((ExecuteInSelfMessage)message).run();
        } else {
            this.handleReceive(message);
        }
    }

    protected abstract void handleReceive(Object var1);

    protected final void ignoreMessage(Object message) {
        this.LOG.debug("Ignoring unhandled message {}", message);
    }

    protected final void unknownMessage(Object message) {
        this.LOG.debug("Received unhandled message {}", message);
        this.unhandled(message);
    }

    protected boolean isValidSender(ActorRef sender) {
        return sender != null && !this.getContext().system().deadLetters().equals((Object)sender);
    }
}

