/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.UntypedActor;
import akka.japi.Procedure;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActorWithMetering;
import org.opendaylight.controller.cluster.reporting.MetricsReporter;

public class MeteringBehavior
implements Procedure<Object> {
    public static final String DOMAIN = "org.opendaylight.controller.actor.metric";
    private static final String MSG_PROCESSING_RATE = "msg-rate";
    private final UntypedActor meteredActor;
    private final MetricRegistry metricRegistry = MetricsReporter.getInstance("org.opendaylight.controller.actor.metric").getMetricsRegistry();
    private String actorQualifiedName;
    private Timer msgProcessingTimer;

    public MeteringBehavior(AbstractUntypedActorWithMetering actor) {
        Preconditions.checkArgument((actor != null ? 1 : 0) != 0, (Object)"actor must not be null");
        this.meteredActor = actor;
        String actorName = actor.getActorNameOverride() != null ? actor.getActorNameOverride() : actor.getSelf().path().name();
        this.init(actorName);
    }

    public MeteringBehavior(UntypedActor actor) {
        Preconditions.checkArgument((actor != null ? 1 : 0) != 0, (Object)"actor must not be null");
        this.meteredActor = actor;
        String actorName = actor.getSelf().path().name();
        this.init(actorName);
    }

    private void init(String actorName) {
        this.actorQualifiedName = this.meteredActor.getSelf().path().parent().toStringWithoutAddress() + "/" + actorName;
        String msgProcessingTime = MetricRegistry.name((String)this.actorQualifiedName, (String[])new String[]{MSG_PROCESSING_RATE});
        this.msgProcessingTimer = this.metricRegistry.timer(msgProcessingTime);
    }

    public void apply(Object message) throws Exception {
        String messageType = message.getClass().getSimpleName();
        String msgProcessingTimeByMsgType = MetricRegistry.name((String)this.actorQualifiedName, (String[])new String[]{MSG_PROCESSING_RATE, messageType});
        Timer msgProcessingTimerByMsgType = this.metricRegistry.timer(msgProcessingTimeByMsgType);
        Timer.Context context = this.msgProcessingTimer.time();
        Timer.Context contextByMsgType = msgProcessingTimerByMsgType.time();
        try {
            this.meteredActor.onReceive(message);
        }
        catch (Throwable e) {
            Throwables.propagateIfPossible((Throwable)e, Exception.class);
            throw new RuntimeException(e);
        }
        finally {
            contextByMsgType.stop();
            context.stop();
        }
    }
}

