/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import com.google.common.annotations.Beta;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.InvalidNormalizedNodeStreamException;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputStreamReader;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeOutputStreamWriter;

@Beta
public final class NormalizedNodeInputOutput {
    private NormalizedNodeInputOutput() {
        throw new UnsupportedOperationException();
    }

    public static NormalizedNodeDataInput newDataInput(@NonNull DataInput input) throws IOException {
        byte marker = input.readByte();
        if (marker != -85) {
            throw new InvalidNormalizedNodeStreamException(String.format("Invalid signature marker: %d", marker));
        }
        short version = input.readShort();
        switch (version) {
            case 1: {
                return new NormalizedNodeInputStreamReader(input, true);
            }
        }
        throw new InvalidNormalizedNodeStreamException(String.format("Unhandled stream version %s", version));
    }

    public static NormalizedNodeDataInput newDataInputWithoutValidation(@NonNull DataInput input) {
        return new NormalizedNodeInputStreamReader(input, false);
    }

    public static NormalizedNodeDataOutput newDataOutput(@NonNull DataOutput output) {
        return new NormalizedNodeOutputStreamWriter(output);
    }
}

