/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.AbstractNormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;

final class NormalizedNodeOutputStreamWriter
extends AbstractNormalizedNodeDataOutput {
    private final Map<String, Integer> stringCodeMap = new HashMap<String, Integer>();

    NormalizedNodeOutputStreamWriter(DataOutput output) {
        super(output);
    }

    @Override
    protected short streamVersion() {
        return 1;
    }

    @Override
    protected void writeQName(QName qname) throws IOException {
        this.writeString(qname.getLocalName());
        this.writeString(qname.getNamespace().toString());
        this.writeString(qname.getRevision().map(Revision::toString).orElse(null));
    }

    @Override
    protected void writeString(String string) throws IOException {
        if (string != null) {
            Integer value = this.stringCodeMap.get(string);
            if (value == null) {
                this.stringCodeMap.put(string, this.stringCodeMap.size());
                this.writeByte(2);
                this.writeUTF(string);
            } else {
                this.writeByte(1);
                this.writeInt(value);
            }
        } else {
            this.writeByte(3);
        }
    }
}

