/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public final class SerializationUtils {
    public static final ThreadLocal<NormalizedNodeDataOutput> REUSABLE_WRITER_TL = new ThreadLocal();
    public static final ThreadLocal<NormalizedNodeDataInput> REUSABLE_READER_TL = new ThreadLocal();

    private SerializationUtils() {
    }

    private static NormalizedNodeDataOutput streamWriter(DataOutput out) {
        NormalizedNodeDataOutput streamWriter = REUSABLE_WRITER_TL.get();
        if (streamWriter == null) {
            streamWriter = NormalizedNodeInputOutput.newDataOutput(out);
        }
        return streamWriter;
    }

    private static NormalizedNodeDataInput streamReader(DataInput in) throws IOException {
        NormalizedNodeDataInput streamReader = REUSABLE_READER_TL.get();
        if (streamReader == null) {
            streamReader = NormalizedNodeInputOutput.newDataInput(in);
        }
        return streamReader;
    }

    public static void serializePathAndNode(YangInstanceIdentifier path, NormalizedNode<?, ?> node, DataOutput out) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(node);
        try {
            NormalizedNodeDataOutput streamWriter = SerializationUtils.streamWriter(out);
            streamWriter.writeNormalizedNode(node);
            streamWriter.writeYangInstanceIdentifier(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error serializing path %s and Node %s", path, node), e);
        }
    }

    public static <T> void deserializePathAndNode(DataInput in, T instance, Applier<T> applier) {
        try {
            NormalizedNodeDataInput streamReader = SerializationUtils.streamReader(in);
            NormalizedNode<?, ?> node = streamReader.readNormalizedNode();
            YangInstanceIdentifier path = streamReader.readYangInstanceIdentifier();
            applier.apply(instance, path, node);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error deserializing path and Node", e);
        }
    }

    private static NormalizedNode<?, ?> tryDeserializeNormalizedNode(DataInput in) throws IOException {
        boolean present = in.readBoolean();
        if (present) {
            NormalizedNodeDataInput streamReader = SerializationUtils.streamReader(in);
            return streamReader.readNormalizedNode();
        }
        return null;
    }

    public static NormalizedNode<?, ?> deserializeNormalizedNode(DataInput in) {
        try {
            return SerializationUtils.tryDeserializeNormalizedNode(in);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error deserializing NormalizedNode", e);
        }
    }

    public static NormalizedNode<?, ?> deserializeNormalizedNode(byte[] bytes) {
        try {
            return SerializationUtils.tryDeserializeNormalizedNode(new DataInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error deserializing NormalizedNode", e);
        }
    }

    public static void serializeNormalizedNode(NormalizedNode<?, ?> node, DataOutput out) {
        try {
            out.writeBoolean(node != null);
            if (node != null) {
                NormalizedNodeDataOutput streamWriter = SerializationUtils.streamWriter(out);
                streamWriter.writeNormalizedNode(node);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error serializing NormalizedNode %s", node), e);
        }
    }

    public static byte[] serializeNormalizedNode(NormalizedNode<?, ?> node) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SerializationUtils.serializeNormalizedNode(node, new DataOutputStream(bos));
        return bos.toByteArray();
    }

    public static void serializePath(YangInstanceIdentifier path, DataOutput out) {
        Preconditions.checkNotNull((Object)path);
        try {
            NormalizedNodeDataOutput streamWriter = SerializationUtils.streamWriter(out);
            streamWriter.writeYangInstanceIdentifier(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error serializing path %s", path), e);
        }
    }

    public static YangInstanceIdentifier deserializePath(DataInput in) {
        try {
            NormalizedNodeDataInput streamReader = SerializationUtils.streamReader(in);
            return streamReader.readYangInstanceIdentifier();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error deserializing path", e);
        }
    }

    public static interface Applier<T> {
        public void apply(T var1, YangInstanceIdentifier var2, NormalizedNode<?, ?> var3);
    }
}

