/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;

@Beta
@NotThreadSafe
public abstract class AbstractDataTreeModificationCursor
implements DataTreeModificationCursor {
    private YangInstanceIdentifier current = YangInstanceIdentifier.EMPTY;

    protected final YangInstanceIdentifier current() {
        return this.current;
    }

    public final void enter(YangInstanceIdentifier.PathArgument child) {
        this.current = this.current.node(child);
    }

    public final void enter(YangInstanceIdentifier.PathArgument ... path) {
        for (YangInstanceIdentifier.PathArgument arg : path) {
            this.enter(arg);
        }
    }

    public final void enter(Iterable<YangInstanceIdentifier.PathArgument> path) {
        for (YangInstanceIdentifier.PathArgument arg : path) {
            this.enter(arg);
        }
    }

    public final void exit() {
        Preconditions.checkState((!this.current.isEmpty() ? 1 : 0) != 0);
        this.current = (YangInstanceIdentifier)Verify.verifyNotNull((Object)this.current.getParent());
    }

    public final void exit(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
        YangInstanceIdentifier next = this.current;
        for (int i = 0; i < depth; ++i) {
            Preconditions.checkState(((next = next.getParent()) != null ? 1 : 0) != 0);
        }
        this.current = next;
    }

    public final Optional<NormalizedNode<?, ?>> readNode(YangInstanceIdentifier.PathArgument child) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
    }
}

