/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.messaging;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import com.google.common.base.Preconditions;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Optional;
import org.opendaylight.controller.cluster.messaging.MessageSliceException;
import org.opendaylight.yangtools.concepts.Identifier;

public final class MessageSliceReply
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Identifier identifier;
    private final int sliceIndex;
    private final MessageSliceException failure;
    private final ActorRef sendTo;

    private MessageSliceReply(Identifier identifier, int sliceIndex, MessageSliceException failure, ActorRef sendTo) {
        this.identifier = (Identifier)Preconditions.checkNotNull((Object)identifier);
        this.sliceIndex = sliceIndex;
        this.sendTo = (ActorRef)Preconditions.checkNotNull((Object)sendTo);
        this.failure = failure;
    }

    public static MessageSliceReply success(Identifier identifier, int sliceIndex, ActorRef sendTo) {
        return new MessageSliceReply(identifier, sliceIndex, null, sendTo);
    }

    public static MessageSliceReply failed(Identifier identifier, MessageSliceException failure, ActorRef sendTo) {
        return new MessageSliceReply(identifier, -1, failure, sendTo);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public int getSliceIndex() {
        return this.sliceIndex;
    }

    public ActorRef getSendTo() {
        return this.sendTo;
    }

    public Optional<MessageSliceException> getFailure() {
        return Optional.ofNullable(this.failure);
    }

    public String toString() {
        return "MessageSliceReply [identifier=" + this.identifier + ", sliceIndex=" + this.sliceIndex + ", failure=" + this.failure + ", sendTo=" + this.sendTo + "]";
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private MessageSliceReply messageSliceReply;

        public Proxy() {
        }

        Proxy(MessageSliceReply messageSliceReply) {
            this.messageSliceReply = messageSliceReply;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.messageSliceReply.identifier);
            out.writeInt(this.messageSliceReply.sliceIndex);
            out.writeObject(this.messageSliceReply.failure);
            out.writeObject(Serialization.serializedActorPath((ActorRef)this.messageSliceReply.sendTo));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Identifier identifier = (Identifier)in.readObject();
            int sliceIndex = in.readInt();
            MessageSliceException failure = (MessageSliceException)in.readObject();
            ActorRef sendTo = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
            this.messageSliceReply = new MessageSliceReply(identifier, sliceIndex, failure, sendTo);
        }

        private Object readResolve() {
            return this.messageSliceReply;
        }
    }
}

