/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.schema.provider.impl;

import akka.dispatch.OnComplete;
import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.cluster.schema.provider.RemoteYangTextSourceProvider;
import org.opendaylight.controller.cluster.schema.provider.impl.YangTextSchemaSourceSerializationProxy;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

@Beta
public class RemoteSchemaProvider
implements SchemaSourceProvider<YangTextSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteSchemaProvider.class);
    private final RemoteYangTextSourceProvider remoteRepo;
    private final ExecutionContext executionContext;
    private static final ExceptionMapper<SchemaSourceException> MAPPER = new ExceptionMapper<SchemaSourceException>("schemaDownload", SchemaSourceException.class){

        protected SchemaSourceException newWithCause(String message, Throwable throwable) {
            return new SchemaSourceException(message, throwable);
        }
    };

    public RemoteSchemaProvider(RemoteYangTextSourceProvider remoteRepo, ExecutionContext executionContext) {
        this.remoteRepo = remoteRepo;
        this.executionContext = executionContext;
    }

    public CheckedFuture<YangTextSchemaSource, SchemaSourceException> getSource(SourceIdentifier sourceIdentifier) {
        LOG.trace("Getting yang schema source for {}", (Object)sourceIdentifier.getName());
        Future<YangTextSchemaSourceSerializationProxy> result = this.remoteRepo.getYangTextSchemaSource(sourceIdentifier);
        final SettableFuture res = SettableFuture.create();
        result.onComplete((Function1)new OnComplete<YangTextSchemaSourceSerializationProxy>(){

            public void onComplete(Throwable throwable, YangTextSchemaSourceSerializationProxy yangTextSchemaSourceSerializationProxy) {
                if (yangTextSchemaSourceSerializationProxy != null) {
                    res.set((Object)yangTextSchemaSourceSerializationProxy.getRepresentation());
                }
                if (throwable != null) {
                    res.setException(throwable);
                }
            }
        }, this.executionContext);
        return Futures.makeChecked((ListenableFuture)res, MAPPER);
    }
}

