/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.impl.password.service;

import java.util.Optional;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.SimpleHashRequest;
import org.apache.shiro.util.ByteSource;
import org.opendaylight.aaa.api.password.service.PasswordHash;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.impl.password.service.PasswordHashImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPasswordHashService
implements PasswordHashService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPasswordHashService.class);
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    public static final int DEFAULT_NUM_ITERATIONS = 20000;
    private final DefaultHashService hashService = new DefaultHashService();

    public DefaultPasswordHashService() {
        this.hashService.setRandomNumberGenerator((RandomNumberGenerator)new SecureRandomNumberGenerator());
        this.hashService.setGeneratePublicSalt(true);
        this.setNumIterations(Optional.of(20000));
        this.setHashAlgorithm(Optional.of(DEFAULT_HASH_ALGORITHM));
    }

    public DefaultPasswordHashService(PasswordServiceConfig passwordServiceConfig) {
        this();
        Optional<Integer> numIterationsOptional = Optional.ofNullable(passwordServiceConfig.getIterations());
        this.setNumIterations(numIterationsOptional);
        Optional<String> hashAlgorithmOptional = Optional.ofNullable(passwordServiceConfig.getAlgorithm());
        this.setHashAlgorithm(hashAlgorithmOptional);
        Optional<String> privateSaltOptional = Optional.ofNullable(passwordServiceConfig.getPrivateSalt());
        this.setPrivateSalt(privateSaltOptional);
    }

    private void setNumIterations(Optional<Integer> numIterationsOptional) {
        if (numIterationsOptional.isPresent()) {
            Integer numIterations = numIterationsOptional.get();
            this.hashService.setHashIterations(numIterations.intValue());
            LOG.info("DefaultPasswordHashService will utilize configured iteration count={}", (Object)numIterations);
        } else {
            this.hashService.setHashIterations(20000);
            LOG.info("DefaultPasswordHashService will utilize default iteration count={}", (Object)20000);
        }
    }

    private void setHashAlgorithm(Optional<String> hashAlgorithmOptional) {
        if (hashAlgorithmOptional.isPresent()) {
            String hashAlgorithm = hashAlgorithmOptional.get();
            this.hashService.setHashAlgorithmName(hashAlgorithm);
            LOG.info("DefaultPasswordHashService will utilize configured algorithm={}", (Object)hashAlgorithm);
        } else {
            this.hashService.setHashAlgorithmName(DEFAULT_HASH_ALGORITHM);
            LOG.info("DefaultPasswordHashService will utilize default algorithm={}", (Object)DEFAULT_HASH_ALGORITHM);
        }
    }

    private void setPrivateSalt(Optional<String> privateSaltOptional) {
        if (privateSaltOptional.isPresent()) {
            this.hashService.setPrivateSalt(ByteSource.Util.bytes((String)privateSaltOptional.get()));
            LOG.info("DefaultPasswordHashService will utilize a configured private salt");
        } else {
            LOG.info("DefaultPasswordHashService will not utilize a private salt, since none was configured");
        }
    }

    public PasswordHash getPasswordHash(String password) {
        HashRequest hashRequest = new HashRequest.Builder().setAlgorithmName(this.hashService.getHashAlgorithmName()).setIterations(this.hashService.getHashIterations()).setSource(ByteSource.Util.bytes((String)password)).build();
        Hash hash = this.hashService.computeHash(hashRequest);
        return PasswordHashImpl.create(hash.getAlgorithmName(), hash.getSalt().toBase64(), hash.getIterations(), hash.toBase64());
    }

    public PasswordHash getPasswordHash(String password, String salt) {
        SimpleHashRequest hashRequest = new SimpleHashRequest(this.hashService.getHashAlgorithmName(), ByteSource.Util.bytes((String)password), ByteSource.Util.bytes((byte[])Base64.decode((String)salt)), this.hashService.getHashIterations());
        Hash hash = this.hashService.computeHash((HashRequest)hashRequest);
        return PasswordHashImpl.create(hash.getAlgorithmName(), hash.getSalt().toBase64(), hash.getIterations(), hash.toBase64());
    }

    public boolean passwordsMatch(String plaintext, String stored, String salt) {
        String hash = this.getPasswordHash(plaintext, salt).getHashedPassword();
        return hash.equals(stored);
    }
}

