/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import java.util.Objects;
import org.opendaylight.jsonrpc.binding.RpcInvocationAdapter;
import org.opendaylight.jsonrpc.impl.SchemaChangeAwareConverter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class ControllerRpcInvocationAdapter
implements RpcInvocationAdapter {
    private SchemaChangeAwareConverter converter;
    private final BindingToNormalizedNodeCodec codec;
    private final DOMSchemaService schemaService;

    public ControllerRpcInvocationAdapter(DOMSchemaService schemaService, BindingToNormalizedNodeCodec codec) {
        this.schemaService = Objects.requireNonNull(schemaService);
        this.converter = new SchemaChangeAwareConverter(schemaService);
        this.codec = codec;
    }

    @Override
    public SchemaChangeAwareConverter converter() {
        return this.converter;
    }

    @Override
    public BindingToNormalizedNodeCodec codec() {
        return this.codec;
    }

    @Override
    public <T extends RpcService> ObjectRegistration<T> registerImpl(Class<T> type, T impl) {
        return new AbstractObjectRegistration<T>(impl){

            protected void removeRegistration() {
            }
        };
    }

    @Override
    public SchemaContext schemaContext() {
        return this.schemaService.getGlobalContext();
    }
}

