/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactory;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactoryProvider;
import org.opendaylight.jsonrpc.bus.spi.EventLoopConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedBusSessionFactoryProvider
implements BusSessionFactoryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedBusSessionFactoryProvider.class);
    private static final String CP_RESOURCE = "META-INF/services/" + BusSessionFactory.class.getName();
    private static final Splitter LINE_SPLITTER = Splitter.on((Pattern)Pattern.compile("\r\n|\n|\r"));
    private static final Set<Class<?>> FACTORY_CLASSES = new HashSet();
    private final ImmutableSet<BusSessionFactory> factories;

    public EmbeddedBusSessionFactoryProvider(EventLoopConfiguration config) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FACTORY_CLASSES.stream().forEach(c -> {
            LOG.debug("Attempting to instantiate '{}'", (Object)c.getName());
            try {
                BusSessionFactory instance = (BusSessionFactory)c.getDeclaredConstructor(EventLoopConfiguration.class).newInstance(config);
                builder.add((Object)instance);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                LOG.warn("Unable to instantiate '{}', factory skipped", (Object)c.getName(), (Object)e);
            }
        });
        this.factories = builder.build();
    }

    public Iterator<BusSessionFactory> getBusSessionFactories() {
        return this.factories.iterator();
    }

    static {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> candidates = cl.getResources(CP_RESOURCE);
            while (candidates.hasMoreElements()) {
                URL current = candidates.nextElement();
                LOG.debug("Loading BusSessionFactories from {}", (Object)current);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Resources.copy((URL)current, (OutputStream)baos);
                List classes = LINE_SPLITTER.splitToList((CharSequence)baos.toString(StandardCharsets.UTF_8.name())).stream().filter(s -> !"".equals(s.trim())).filter(s -> !s.trim().startsWith("#")).collect(Collectors.toList());
                classes.iterator().forEachRemaining(c -> {
                    try {
                        LOG.debug("Attempting to load '{}'", c);
                        FACTORY_CLASSES.add(Class.forName(c, true, cl));
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Unable to load '{}', skipping this factory", c);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

