/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.hmap;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;

public enum DataType {
    OPERATIONAL_DATA,
    CONFIGURATION_DATA,
    RPC,
    NOTIFICATION;

    private static final ImmutableMap<LogicalDatastoreType, DataType> DS_MAP;

    public static DataType forDatastore(LogicalDatastoreType ldt) {
        return (DataType)((Object)Objects.requireNonNull(DS_MAP.get((Object)ldt), "Can't map data type into datastore using type " + ldt));
    }

    static {
        DS_MAP = ImmutableMap.builder().put((Object)LogicalDatastoreType.CONFIGURATION, (Object)CONFIGURATION_DATA).put((Object)LogicalDatastoreType.OPERATIONAL, (Object)OPERATIONAL_DATA).build();
    }
}

