/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.SchemaContextProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.SimpleSchemaContext;

public class BuiltinSchemaContextProvider
implements SchemaContextProvider {
    private final SchemaContext schemaContext;

    public BuiltinSchemaContextProvider(@Nonnull SchemaContext schemaContext) {
        this.schemaContext = (SchemaContext)Preconditions.checkNotNull((Object)schemaContext);
    }

    @Override
    public SchemaContext createSchemaContext(Peer peer) {
        Set<Module> moduleIds = peer.getModules().stream().map(YangIdentifier::getValue).map(m -> {
            Optional<Module> possibleModule = Util.findModuleWithLatestRevision(this.schemaContext, m);
            Preconditions.checkState((boolean)possibleModule.isPresent(), (String)"No model '%s' in global schema context", (Object)m);
            return possibleModule.get();
        }).collect(Collectors.toSet());
        return this.buildSchemaContext(moduleIds);
    }

    private SchemaContext buildSchemaContext(Set<Module> modules) {
        HashSet resolved = Sets.newHashSet();
        resolved.addAll(modules);
        modules.stream().forEach(m -> resolved.addAll(m.getImports().stream().map(mi -> (Module)this.schemaContext.findModule(mi.getModuleName(), mi.getRevision()).get()).collect(Collectors.toSet())));
        return SimpleSchemaContext.forModules((Set)resolved);
    }
}

