/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.DataChangeNotification;
import org.opendaylight.jsonrpc.model.DataChangeNotificationPublisher;
import org.opendaylight.jsonrpc.model.ListenerKey;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeListenerRegistration
implements ListenerRegistration<DOMDataTreeChangeListener>,
DOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(DataChangeListenerRegistration.class);
    private final DataChangeNotificationPublisher publisher;
    private final YangInstanceIdentifier path;
    private final ListenerRegistration<DataChangeListenerRegistration> delegate;
    private final JsonConverter converter;
    private final Consumer<ListenerKey> closeCallback;
    private ListenerKey listenerKey;

    public DataChangeListenerRegistration(@Nonnull YangInstanceIdentifier path, @Nonnull Consumer<ListenerKey> closeCallback, @Nonnull DOMDataBroker domDataBroker, @Nonnull JsonConverter converter, @Nonnull LogicalDatastoreType store, @Nonnull DataChangeNotificationPublisher publisher, @Nonnull ListenerKey listenerKey) {
        this.path = Objects.requireNonNull(path);
        this.closeCallback = Objects.requireNonNull(closeCallback);
        this.converter = Objects.requireNonNull(converter);
        this.publisher = Objects.requireNonNull(publisher);
        this.listenerKey = Objects.requireNonNull(listenerKey);
        Objects.requireNonNull(domDataBroker);
        Objects.requireNonNull(store);
        DOMDataTreeChangeService dtcs = (DOMDataTreeChangeService)domDataBroker.getExtensions().get(DOMDataTreeChangeService.class);
        this.delegate = dtcs.registerDataTreeChangeListener(new DOMDataTreeIdentifier(store, path), (DOMDataTreeChangeListener)this);
    }

    public void close() {
        LOG.debug("Closing notification publisher for path {}", (Object)this.path);
        try {
            Stream.of(this.publisher, this.delegate).forEach(c -> Util.closeNullableWithExceptionCallback(c, e -> LOG.warn("Unable to close {}", c, e)));
            this.closeCallback.accept(this.listenerKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed while closing registration", e);
        }
    }

    public DOMDataTreeChangeListener getInstance() {
        return this;
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> treeChanges) {
        DataChangeNotification dcn = new DataChangeNotification(treeChanges.stream().map(dtc -> this.converter.toBus(dtc.getRootPath(), dtc.getRootNode().getDataAfter().orElse(null))).collect(Collectors.toSet()));
        LOG.debug("Sending notification {}", (Object)dcn);
        this.publisher.notifyListener(dcn);
    }
}

