/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.model.InbandModelsService;
import org.opendaylight.jsonrpc.model.SchemaContextProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpoints;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.RFC7950Reactors;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveSchemaContext;

public final class InbandModelsSchemaContextProvider
implements SchemaContextProvider {
    private final TransportFactory transportFactory;

    public static InbandModelsSchemaContextProvider create(TransportFactory transportFactory) {
        return new InbandModelsSchemaContextProvider(transportFactory);
    }

    private InbandModelsSchemaContextProvider(TransportFactory transportFactory) {
        this.transportFactory = Objects.requireNonNull(transportFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaContext createSchemaContext(Peer peer) {
        Objects.requireNonNull(peer.getRpcEndpoints(), "RPC endpoint is mandatory for for inband models");
        RpcEndpoints enpodint = peer.getRpcEndpoints().stream().filter(rpc -> rpc.getPath().equals("{}")).findFirst().orElseThrow(() -> new IllegalArgumentException("Missing RPC endpoint for root path"));
        Objects.requireNonNull(enpodint.getEndpointUri().getValue(), "RPC endpoint not set");
        try (InbandModelsService requester = (InbandModelsService)this.transportFactory.endpointBuilder().requester().createProxy(InbandModelsService.class, enpodint.getEndpointUri().getValue());){
            CrossSourceStatementReactor.BuildAction reactor = RFC7950Reactors.defaultReactor().newBuild();
            requester.getModules().forEach(m -> {
                try {
                    reactor.addSource((StatementStreamSource)YangStatementStreamSource.create((YangTextSchemaSource)YangTextSchemaSource.delegateForByteSource((String)(m.getName() + ".yang"), (ByteSource)ByteSource.wrap((byte[])m.getContent().getBytes(StandardCharsets.UTF_8)))));
                }
                catch (IOException | YangSyntaxErrorException e) {
                    throw new IllegalStateException("Failed to add YANG source for " + m.getName(), e);
                }
            });
            EffectiveSchemaContext effectiveSchemaContext = reactor.buildEffective();
            return effectiveSchemaContext;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI is invalid", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to build SchemaContext", e);
        }
    }
}

