/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
final class JsonRPCDOMRpcResultFuture
extends AbstractFuture<DOMRpcResult> {
    private volatile Exception exception = null;
    private final Consumer<JsonRPCDOMRpcResultFuture> consumer;
    private final SettableFuture<DOMRpcResult> jsonRPCFuture;
    private final SettableFuture<String> uuidFuture;
    private String uuid;
    private final NormalizedNode<?, ?> input;
    private final SchemaPath type;
    private boolean pollingForResult;

    JsonRPCDOMRpcResultFuture(SettableFuture<DOMRpcResult> jsonRPCFuture, SettableFuture<String> uuidFuture, Consumer<JsonRPCDOMRpcResultFuture> consumer, SchemaPath type, NormalizedNode<?, ?> input) {
        this.jsonRPCFuture = jsonRPCFuture;
        this.uuidFuture = uuidFuture;
        this.consumer = consumer;
        this.type = type;
        this.input = input;
        this.pollingForResult = false;
    }

    static Future<DOMRpcResult> create(SettableFuture<DOMRpcResult> jsonRPCFuture, SettableFuture<String> uuidFuture, Consumer<JsonRPCDOMRpcResultFuture> consumer, SchemaPath type, NormalizedNode<?, ?> input) {
        return new JsonRPCDOMRpcResultFuture(jsonRPCFuture, uuidFuture, consumer, type, input);
    }

    public void setUuid(String uuid) {
        this.uuidFuture.set((Object)uuid);
    }

    public SchemaPath getType() {
        return this.type;
    }

    public NormalizedNode<?, ?> getInput() {
        return this.input;
    }

    boolean isPollingForResult() {
        return this.pollingForResult;
    }

    void startPollingForResult() {
        this.pollingForResult = true;
    }

    JsonObject formMetadata() {
        JsonObject result = new JsonObject();
        if (this.uuid == null) {
            result.add("async", (JsonElement)new JsonPrimitive(UUID.randomUUID().toString()));
        } else {
            result.add("async", (JsonElement)new JsonPrimitive(UUID.fromString(this.uuid).toString()));
        }
        return result;
    }

    public UUID getUuid() {
        return this.uuid == null ? null : UUID.fromString(this.uuid);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.uuidFuture.cancel(true);
        return this.jsonRPCFuture.cancel(mayInterruptIfRunning);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.jsonRPCFuture.addListener(listener, executor);
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public boolean set(@Nullable DOMRpcResult value) {
        return this.jsonRPCFuture.set((Object)value);
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public boolean setException(Exception ex) {
        this.uuid = null;
        this.exception = ex;
        if (!this.uuidFuture.isDone()) {
            this.uuidFuture.set(null);
        }
        this.jsonRPCFuture.set(null);
        return true;
    }

    public DOMRpcResult get() throws InterruptedException, ExecutionException {
        this.uuid = (String)this.uuidFuture.get();
        if (this.uuid != null) {
            this.consumer.accept(this);
        }
        DOMRpcResult result = (DOMRpcResult)this.jsonRPCFuture.get();
        if (this.exception == null) {
            return result;
        }
        throw new ExecutionException(this.exception);
    }

    public DOMRpcResult get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        this.uuid = (String)this.uuidFuture.get(timeout, unit);
        if (this.uuid != null) {
            this.consumer.accept(this);
        }
        DOMRpcResult result = (DOMRpcResult)this.jsonRPCFuture.get(timeout, unit);
        if (this.exception == null) {
            return result;
        }
        throw new ExecutionException(this.exception);
    }

    public boolean isCancelled() {
        return this.jsonRPCFuture.isCancelled();
    }

    public boolean isDone() {
        return this.jsonRPCFuture.isDone();
    }
}

