/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.impl.DOMDataTreeChangeListenerAdapter;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.JsonRPCTx;
import org.opendaylight.jsonrpc.impl.RemoteShardAware;
import org.opendaylight.jsonrpc.impl.TxChain;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.ListenerKey;
import org.opendaylight.jsonrpc.model.RemoteGovernance;
import org.opendaylight.jsonrpc.model.RemoteOmShard;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRPCDataBroker
extends RemoteShardAware
implements DOMDataBroker,
DOMDataTreeChangeService {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRPCDataBroker.class);
    private static final JsonObject TOP = new JsonObject();
    private final ClassToInstanceMap<DOMDataBrokerExtension> extensions = ImmutableClassToInstanceMap.builder().put(DOMDataTreeChangeService.class, (Object)this).build();

    public JsonRPCDataBroker(@Nonnull Peer peer, @Nonnull SchemaContext schemaContext, @Nonnull HierarchicalEnumMap<JsonElement, DataType, String> pathMap, @Nonnull TransportFactory transportFactory, @Nullable RemoteGovernance governance, @Nonnull JsonConverter jsonConverter) {
        super(schemaContext, transportFactory, pathMap, jsonConverter, peer);
        if (peer.getDataConfigEndpoints() != null) {
            Util.populateFromEndpointList(pathMap, peer.getDataConfigEndpoints(), DataType.CONFIGURATION_DATA);
        } else if (governance != null) {
            pathMap.put((JsonElement)TOP, DataType.CONFIGURATION_DATA, governance.governance(Util.store2str(Util.store2int(LogicalDatastoreType.CONFIGURATION)), peer.getName(), (Object)TOP));
        }
        if (peer.getDataOperationalEndpoints() != null) {
            Util.populateFromEndpointList(pathMap, peer.getDataOperationalEndpoints(), DataType.OPERATIONAL_DATA);
        } else if (governance != null) {
            pathMap.put((JsonElement)TOP, DataType.OPERATIONAL_DATA, governance.governance(Util.store2str(Util.store2int(LogicalDatastoreType.OPERATIONAL)), peer.getName(), (Object)TOP));
        }
        LOG.info("Broker Instantiated for {}", (Object)peer.getName());
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new JsonRPCTx(this.transportFactory, this.peer, (HierarchicalEnumMap<JsonElement, DataType, String>)this.pathMap, this.jsonConverter, this.schemaContext);
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return new JsonRPCTx(this.transportFactory, this.peer, (HierarchicalEnumMap<JsonElement, DataType, String>)this.pathMap, this.jsonConverter, this.schemaContext);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new JsonRPCTx(this.transportFactory, this.peer, (HierarchicalEnumMap<JsonElement, DataType, String>)this.pathMap, this.jsonConverter, this.schemaContext);
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        return new TxChain(this, listener, this.transportFactory, this.pathMap, this.jsonConverter, this.schemaContext, this.peer);
    }

    public @NonNull ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return this.extensions;
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(DOMDataTreeIdentifier treeId, L listener) {
        DOMDataTreeChangeListenerAdapter adapter;
        ListenerKey listenerKey;
        JsonElement busPath = this.jsonConverter.toBus(treeId.getRootIdentifier(), null).getPath();
        final RemoteOmShard shard = this.getShard(treeId.getDatastoreType(), busPath);
        try {
            listenerKey = shard.addListener(Util.store2int(treeId.getDatastoreType()), "", busPath);
            adapter = new DOMDataTreeChangeListenerAdapter(listener, this.transportFactory, listenerKey.getUri(), this.jsonConverter, this.schemaContext);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid URI provided from remote shard", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create subscriber", e);
        }
        return new AbstractListenerRegistration<L>(listener){

            protected void removeRegistration() {
                shard.deleteListener(listenerKey.getUri(), listenerKey.getName());
                adapter.close();
            }
        };
    }
}

