/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcNotificationMessage;
import org.opendaylight.jsonrpc.bus.messagelib.NotificationMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.impl.AbstractJsonRPCComponent;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.NotificationState;
import org.opendaylight.jsonrpc.model.RemoteGovernance;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRPCNotificationService
extends AbstractJsonRPCComponent
implements DOMNotificationService,
NotificationMessageHandler,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRPCNotificationService.class);
    private final Multimap<SchemaPath, DOMNotificationListener> listeners = HashMultimap.create();
    private final Map<String, NotificationState> mappedNotifications = new HashMap<String, NotificationState>();

    public JsonRPCNotificationService(@Nonnull Peer peer, @Nonnull SchemaContext schemaContext, @Nonnull HierarchicalEnumMap<JsonElement, DataType, String> pathMap, @Nonnull JsonConverter jsonConverter, @Nonnull TransportFactory transportFactory, @Nullable RemoteGovernance governance) throws URISyntaxException {
        super(schemaContext, transportFactory, pathMap, jsonConverter, peer);
        if (peer.getNotificationEndpoints() != null) {
            Util.populateFromEndpointList(pathMap, peer.getNotificationEndpoints(), DataType.NOTIFICATION);
        }
        for (NotificationDefinition def : schemaContext.getNotifications()) {
            QNameModule qm = def.getQName().getModule();
            Optional possibleModule = schemaContext.findModule(qm.getNamespace(), qm.getRevision());
            if (!possibleModule.isPresent()) {
                LOG.error("Notification {} cannot be mapped, module not found", (Object)def.getQName().getLocalName());
                continue;
            }
            String topLevel = jsonConverter.makeQualifiedName((Module)possibleModule.get(), def.getQName());
            JsonObject path = new JsonObject();
            path.add(topLevel, (JsonElement)new JsonObject());
            String notificationEndpoint = this.getEndpoint(peer, pathMap, governance, path);
            if (notificationEndpoint != null) {
                LOG.info("Notification {} mapped to {}", (Object)topLevel, (Object)notificationEndpoint);
                this.mappedNotifications.put(def.getQName().getLocalName(), new NotificationState(def, notificationEndpoint, this, transportFactory));
                continue;
            }
            LOG.error("Notifications {} cannot be mapped, no known endpoint", (Object)topLevel);
        }
    }

    private String getEndpoint(Peer peer, HierarchicalEnumMap<JsonElement, DataType, String> pathMap, RemoteGovernance governance, JsonObject path) {
        String notificationEndpoint = pathMap.lookup((JsonElement)path, DataType.NOTIFICATION).orElse(null);
        LOG.debug("Notification endpoint - map lookup is  {}", (Object)notificationEndpoint);
        if (notificationEndpoint == null && governance != null && (notificationEndpoint = governance.governance(-1, peer.getName(), (Object)path)) != null) {
            pathMap.put((JsonElement)path, DataType.NOTIFICATION, notificationEndpoint);
        }
        return notificationEndpoint;
    }

    @Override
    public void close() {
        this.mappedNotifications.values().stream().forEach(NotificationState::close);
        this.mappedNotifications.clear();
        this.listeners.clear();
    }

    public synchronized void publishNotification(DOMNotification notification) {
        this.listeners.get((Object)notification.getType()).forEach(l -> {
            LOG.debug("Invoking listener {} with notification {}", l, (Object)notification);
            l.onNotification(notification);
        });
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(final @Nonnull T listener, final @Nonnull Collection<SchemaPath> types) {
        for (SchemaPath type : types) {
            this.listeners.put((Object)type, listener);
        }
        return new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
                for (SchemaPath type : types) {
                    JsonRPCNotificationService.this.listeners.remove((Object)type, (Object)listener);
                }
            }
        };
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(@Nonnull T listener, SchemaPath ... types) {
        return this.registerNotificationListener(listener, Lists.newArrayList((Object[])types));
    }

    public void handleNotification(JsonRpcNotificationMessage notification) {
        this.publishNotification(this.jsonConverter.notificationConvert(notification, this.mappedNotifications));
    }
}

