/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.FluentFuture;
import com.google.gson.JsonElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.RemoteShardAware;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.JSONRPCArg;
import org.opendaylight.jsonrpc.model.RemoteOmShard;
import org.opendaylight.jsonrpc.model.TransactionListener;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRPCTx
extends RemoteShardAware
implements DOMDataTreeReadWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRPCTx.class);
    private static final JSONCodecFactorySupplier CODEC = JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02;
    private static final Function<String, RpcError> ERROR_MAPPER = msg -> RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"commit", (String)msg);
    private static final FluentFuture<Optional<NormalizedNode<?, ?>>> NO_DATA = FluentFutures.immediateFluentFuture(Optional.empty());
    private final Map<String, RemoteOmShard> endPointMap;
    private final Map<String, String> txIdMap;
    private final List<TransactionListener> listeners = new CopyOnWriteArrayList<TransactionListener>();

    public JsonRPCTx(@Nonnull TransportFactory transportFactory, @Nonnull Peer peer, @Nonnull HierarchicalEnumMap<JsonElement, DataType, String> pathMap, @Nonnull JsonConverter jsonConverter, @Nonnull SchemaContext schemaContext) {
        super(schemaContext, transportFactory, pathMap, jsonConverter, peer);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)peer.getName()) ? 1 : 0) != 0, (Object)"Peer name is missing");
        this.endPointMap = new HashMap<String, RemoteOmShard>();
        this.txIdMap = new HashMap<String, String>();
    }

    private RemoteOmShard getOmShard(LogicalDatastoreType store, JsonElement path) {
        return this.endPointMap.computeIfAbsent(this.lookupEndPoint(store, path), shard -> this.getShard(store, path));
    }

    private String getTxId(String endpoint) {
        return this.txIdMap.computeIfAbsent(endpoint, k -> this.endPointMap.get(k).txid());
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 33[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FluentFuture<Optional<NormalizedNode<?, ?>>> readFailure(String message, Exception ex) {
        return FluentFutures.immediateFailedFluentFuture((Throwable)new ReadFailedException(message, (Throwable)ex, new RpcError[0]));
    }

    private FluentFuture<Optional<NormalizedNode<?, ?>>> readFailure(String message) {
        return this.readFailure(message, null);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        try {
            JSONRPCArg arg = this.jsonConverter.toBus(path, null);
            RemoteOmShard omshard = this.getOmShard(store, arg.getPath());
            return FluentFutures.immediateBooleanFluentFuture((boolean)omshard.exists(Util.store2str(Util.store2int(store)), this.peer.getName(), arg.getPath()));
        }
        catch (Exception e) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply(e));
        }
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        JSONRPCArg arg = this.jsonConverter.toBusWithStripControl(path, data, true);
        if (arg.getData() != null) {
            this.getOmShard(store, arg.getPath()).put(this.getTxId(this.lookupEndPoint(store, arg.getPath())), Util.store2str(Util.store2int(store)), this.peer.getName(), arg.getPath(), arg.getData());
        }
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        JSONRPCArg arg = this.jsonConverter.toBus(path, data);
        RemoteOmShard omshard = this.getOmShard(store, arg.getPath());
        omshard.merge(this.getTxId(this.lookupEndPoint(store, arg.getPath())), Util.store2str(Util.store2int(store)), this.peer.getName(), arg.getPath(), arg.getData());
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        JSONRPCArg arg = this.jsonConverter.toBus(path, null);
        RemoteOmShard omshard = this.getOmShard(store, arg.getPath());
        omshard.delete(this.getTxId(this.lookupEndPoint(store, arg.getPath())), Util.store2str(Util.store2int(store)), this.peer.getName(), arg.getPath());
    }

    public Object getIdentifier() {
        return this;
    }

    public boolean cancel() {
        boolean result = true;
        for (Map.Entry<String, RemoteOmShard> entry : this.endPointMap.entrySet()) {
            RemoteOmShard omshard = this.endPointMap.get(entry.getKey());
            if (this.getTxId(entry.getKey()) == null) continue;
            result &= omshard.cancel(this.getTxId(entry.getKey()));
        }
        this.listeners.forEach(listener -> listener.onCancel(this));
        return result;
    }

    public FluentFuture<? extends CommitInfo> commit() {
        this.listeners.forEach(txl -> txl.onSubmit(this));
        boolean result = true;
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<String, RemoteOmShard> entry : this.endPointMap.entrySet()) {
            String txid = this.getTxId(entry.getKey());
            if (entry.getValue().commit(txid)) continue;
            result = false;
            LOG.debug("Commit of {} failed, requesting more info", (Object)txid);
            errors.addAll(entry.getValue().error(txid));
        }
        if (result) {
            this.listeners.forEach(txListener -> txListener.onSuccess(this));
            return CommitInfo.emptyFluentFuture();
        }
        TransactionCommitFailedException failure = new TransactionCommitFailedException("Commit of transaction " + this.getIdentifier() + " failed", (RpcError[])errors.stream().map(ERROR_MAPPER).toArray(RpcError[]::new));
        this.listeners.forEach(arg_0 -> this.lambda$commit$7((Throwable)failure, arg_0));
        return FluentFutures.immediateFailedFluentFuture((Throwable)failure);
    }

    AutoCloseable addCallback(TransactionListener listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }

    private /* synthetic */ void lambda$commit$7(Throwable failure, TransactionListener txListener) {
        txListener.onFailure(this, failure);
    }
}

