/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.impl.AbstractJsonRPCComponent;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.JsonRPCDOMRpcResultFuture;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.RemoteGovernance;
import org.opendaylight.jsonrpc.model.RpcExceptionImpl;
import org.opendaylight.jsonrpc.model.RpcState;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonRPCtoRPCBridge
extends AbstractJsonRPCComponent
implements DOMRpcService,
AutoCloseable,
Consumer<JsonRPCDOMRpcResultFuture> {
    private static final int MAX_QUEUE_DEPTH = 64;
    private static final Logger LOG = LoggerFactory.getLogger(JsonRPCtoRPCBridge.class);
    private final Collection<DOMRpcIdentifier> availableRpcs;
    private final Map<String, RpcState> mappedRpcs;
    private final BlockingQueue<JsonRPCDOMRpcResultFuture> requestQueue = new ArrayBlockingQueue<JsonRPCDOMRpcResultFuture>(64);
    private final Future<?> processorFuture;
    private final ExecutorService executorService;
    private volatile boolean shuttingDown = false;

    public JsonRPCtoRPCBridge(@Nonnull Peer peer, @Nonnull SchemaContext schemaContext, @Nonnull HierarchicalEnumMap<JsonElement, DataType, String> pathMap, @Nullable RemoteGovernance governance, @Nonnull TransportFactory transportFactory, @Nonnull JsonConverter jsonConverter) throws URISyntaxException {
        super(schemaContext, transportFactory, pathMap, jsonConverter, peer);
        if (peer.getRpcEndpoints() != null) {
            Util.populateFromEndpointList(pathMap, peer.getRpcEndpoints(), DataType.RPC);
        }
        ImmutableList.Builder availableRpcsBuilder = ImmutableList.builder();
        ImmutableMap.Builder mappedRpcsBuilder = ImmutableMap.builder();
        for (RpcDefinition def : schemaContext.getOperations()) {
            this.addRpcDefinition(peer, governance, def, (ImmutableList.Builder<DOMRpcIdentifier>)availableRpcsBuilder, (ImmutableMap.Builder<String, RpcState>)mappedRpcsBuilder);
        }
        this.mappedRpcs = mappedRpcsBuilder.build();
        this.availableRpcs = availableRpcsBuilder.build();
        if (this.mappedRpcs.isEmpty()) {
            LOG.info("No RPCs to map for {}", (Object)peer.getName());
            this.executorService = null;
            this.processorFuture = Futures.immediateFuture(null);
        } else {
            this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("jsonrpc-async-dispatch-" + peer.getName() + "-%d").build());
            this.processorFuture = this.executorService.submit(this::requestProcessorThreadLoop);
        }
        LOG.info("RPC bridge instantiated for '{}' with {} methods", (Object)peer.getName(), (Object)this.mappedRpcs.size());
    }

    private void addRpcDefinition(Peer peer, RemoteGovernance governance, RpcDefinition def, ImmutableList.Builder<DOMRpcIdentifier> toRpcIdentifiers, ImmutableMap.Builder<String, RpcState> toMappedRpcs) throws URISyntaxException {
        QNameModule qmodule = def.getQName().getModule();
        Optional possibleModule = this.schemaContext.findModule(qmodule.getNamespace(), qmodule.getRevision());
        Preconditions.checkState((boolean)possibleModule.isPresent(), (String)"RPC %s cannot be mapped, module not found", (Object)def.getQName().getLocalName());
        String topLevel = this.jsonConverter.makeQualifiedName((Module)possibleModule.get(), def.getQName());
        JsonObject path = new JsonObject();
        path.add(topLevel, (JsonElement)new JsonObject());
        String methodEndpoint = this.pathMap.lookup(path, DataType.RPC).orElse(null);
        LOG.debug("Method endpoint - map lookup is  {}", (Object)methodEndpoint);
        if (methodEndpoint == null) {
            Preconditions.checkNotNull((Object)governance, (String)"Can't create mapping lookup because governance was not provided for peer %s", (Object)peer.toString());
            methodEndpoint = governance.governance(-1, peer.getName(), (Object)path);
            if (methodEndpoint != null) {
                this.pathMap.put(path, DataType.RPC, methodEndpoint);
            }
        }
        LOG.debug("Method endpoint - governance+map lookup is  {}", (Object)methodEndpoint);
        if (methodEndpoint != null) {
            LOG.debug("RPC {} mapped to {}", (Object)topLevel, (Object)methodEndpoint);
            toMappedRpcs.put((Object)def.getQName().getLocalName(), (Object)new RpcState(def.getQName().getLocalName(), def, methodEndpoint, this.transportFactory));
            toRpcIdentifiers.add((Object)DOMRpcIdentifier.create((SchemaPath)def.getPath()));
        } else {
            LOG.error("RPC {} cannot be mapped, no known endpoint", (Object)topLevel);
        }
    }

    private boolean isNotEmpty(ContainerSchemaNode arg) {
        return arg != null && !arg.getChildNodes().isEmpty();
    }

    @Nonnull
    public FluentFuture<DOMRpcResult> invokeRpc(@Nonnull SchemaPath type, @Nullable NormalizedNode<?, ?> input) {
        if (this.shuttingDown) {
            return this.bridgeNotAvailable();
        }
        SettableFuture futureResult = SettableFuture.create();
        SettableFuture asyncUUID = SettableFuture.create();
        JsonRPCDOMRpcResultFuture postponedResult = new JsonRPCDOMRpcResultFuture((SettableFuture<DOMRpcResult>)futureResult, (SettableFuture<String>)asyncUUID, this, type, input);
        try {
            this.requestQueue.put(postponedResult);
        }
        catch (InterruptedException e) {
            return this.bridgeNotAvailable();
        }
        return postponedResult;
    }

    private FluentFuture<DOMRpcResult> bridgeNotAvailable() {
        return FluentFutures.immediateFluentFuture((Object)this.resultFromException(new IllegalStateException("RPC Bridge shutting down")));
    }

    public JsonRPCDOMRpcResultFuture deQueue() throws InterruptedException {
        return this.requestQueue.take();
    }

    public void flushQueue() {
        JsonRPCDOMRpcResultFuture request = (JsonRPCDOMRpcResultFuture)((Object)this.requestQueue.poll());
        while (request != null) {
            request.setException((Exception)((Object)new RpcExceptionImpl("Execution interrupted due to broker shutdown")));
            request = (JsonRPCDOMRpcResultFuture)((Object)this.requestQueue.poll());
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS"})
    public void doInvokeRpc(JsonRPCDOMRpcResultFuture request) {
        QName rpcQName = request.getType().getLastComponent();
        JsonObject jsonForm = null;
        try {
            RpcState rpcState = this.mappedRpcs.get(rpcQName.getLocalName());
            Preconditions.checkArgument((rpcState != null ? 1 : 0) != 0, (String)"Unknown rpc %s, available rpcs: %s", (Object)rpcQName, this.mappedRpcs.keySet());
            if (!request.isPollingForResult() && this.isNotEmpty(rpcState.rpc().getInput())) {
                Preconditions.checkArgument((boolean)(request.getInput() instanceof ContainerNode), (String)"Transforming an rpc with input: %s, payload has to be a container, but was: %s", (Object)rpcQName, request.getInput());
                jsonForm = this.jsonConverter.rpcConvert(rpcState.rpc().getInput().getPath(), (ContainerNode)request.getInput());
            }
            JsonElement jsonResult = rpcState.sendRequest((JsonElement)jsonForm, request.formMetadata());
            if (rpcState.lastError() == null) {
                DefaultDOMRpcResult toODL;
                if (!request.isPollingForResult()) {
                    if (rpcState.lastMetadata() == null) {
                        request.setUuid(null);
                    } else {
                        if (rpcState.lastMetadata().get("async") != null) {
                            request.setUuid(rpcState.lastMetadata().get("async").getAsString());
                            return;
                        }
                        LOG.error("Invalid Request Metadata");
                    }
                } else if (JsonRPCtoRPCBridge.shouldRequeue(jsonResult, rpcState.lastMetadata())) {
                    if (!this.requestQueue.offer(request)) {
                        request.setException((Exception)((Object)new RpcExceptionImpl("Queue Full")));
                    }
                    return;
                }
                if (this.isNotEmpty(rpcState.rpc().getOutput())) {
                    DataContainerNodeAttrBuilder resultBuilder = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)rpcState.rpc().getOutput().getQName()));
                    toODL = this.extractResult(rpcState, jsonResult, (DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)resultBuilder);
                } else {
                    toODL = new DefaultDOMRpcResult((NormalizedNode)null);
                }
                request.set((DOMRpcResult)toODL);
            } else {
                request.setException((Exception)((Object)new RpcExceptionImpl(rpcState.lastError().getMessage())));
            }
        }
        catch (RuntimeException e) {
            request.setException(e);
            return;
        }
    }

    @VisibleForTesting
    static boolean shouldRequeue(JsonElement result, JsonObject metadata) {
        return (result == null || result.isJsonNull()) && metadata != null;
    }

    @Override
    public void accept(JsonRPCDOMRpcResultFuture request) {
        request.startPollingForResult();
        if (!this.requestQueue.offer(request)) {
            LOG.error("Failed to requeue UUID {} because queue is full", (Object)request.getUuid());
            request.set(null);
            request.setException((Exception)((Object)new RpcExceptionImpl("Queue Full")));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DOMRpcResult extractResult(RpcState rpcState, JsonElement jsonResult, DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> resultBuilder) {
        try (NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from(resultBuilder);){
            DOMRpcResult dOMRpcResult = this.extractResultInternal(rpcState, jsonResult, resultBuilder, streamWriter);
            return dOMRpcResult;
        }
        catch (IOException e1) {
            LOG.error("Failed to close JSON parser", (Throwable)e1);
            return this.resultFromException(e1);
        }
        catch (RuntimeException e) {
            LOG.error("Failed invoke RPC method", (Throwable)e);
            return this.resultFromException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DOMRpcResult extractResultInternal(RpcState rpcState, JsonElement jsonResult, DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> resultBuilder, NormalizedNodeStreamWriter streamWriter) {
        JsonElement wrapper;
        if (jsonResult.isJsonPrimitive()) {
            JsonObject obj = new JsonObject();
            obj.add(((DataSchemaNode)rpcState.rpc().getOutput().getChildNodes().iterator().next()).getQName().getLocalName(), jsonResult);
            wrapper = obj;
        } else {
            wrapper = jsonResult;
        }
        try (JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)streamWriter, (JSONCodecFactory)JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(this.schemaContext), (SchemaNode)rpcState.rpc().getOutput());){
            jsonParser.parse(new JsonReader((Reader)new StringReader(wrapper.toString())));
            DefaultDOMRpcResult defaultDOMRpcResult = new DefaultDOMRpcResult(resultBuilder.build());
            return defaultDOMRpcResult;
        }
        catch (IOException e) {
            LOG.error("Failed to process JSON", (Throwable)e);
            return this.resultFromException(e);
        }
    }

    private DOMRpcResult resultFromException(Exception ex) {
        return new DefaultDOMRpcResult(new RpcError[]{RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.RPC, (String)"internal-error", (String)ex.getMessage())});
    }

    @Nonnull
    public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(@Nonnull T listener) {
        LOG.info("registered RPC implementation for json rpc broker");
        listener.onRpcAvailable(this.availableRpcs);
        return new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
            }
        };
    }

    @Override
    public void close() {
        this.shuttingDown = true;
        this.processorFuture.cancel(true);
        this.mappedRpcs.values().stream().forEach(RpcState::close);
    }

    private void requestProcessorThreadLoop() {
        try {
            while (this.opStatus()) {
                this.doInvokeRpc(this.deQueue());
            }
        }
        catch (InterruptedException e) {
            this.flushQueue();
            Thread.currentThread().interrupt();
        }
    }

    public boolean opStatus() {
        return !this.shuttingDown;
    }
}

