/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonElement;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumHashMap;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.hmap.JsonPathCodec;
import org.opendaylight.jsonrpc.impl.BuiltinSchemaContextProvider;
import org.opendaylight.jsonrpc.impl.GovernanceSchemaContextProvider;
import org.opendaylight.jsonrpc.impl.InbandModelsSchemaContextProvider;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.JsonRPCDataBroker;
import org.opendaylight.jsonrpc.impl.JsonRPCNotificationService;
import org.opendaylight.jsonrpc.impl.JsonRPCtoRPCBridge;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.model.MutablePeer;
import org.opendaylight.jsonrpc.model.RemoteGovernance;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ActualEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ActualEndpointsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ActualEndpointsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataConfigEndpointsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataOperationalEndpointsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.NotificationEndpointsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpointsBuilder;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedPeerContext
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MappedPeerContext.class);
    private final Peer peer;
    private final HierarchicalEnumMap<JsonElement, DataType, String> pathMap = HierarchicalEnumHashMap.create(DataType.class, JsonPathCodec.create());
    private final JsonConverter jsonConverter;
    private final JsonRPCtoRPCBridge rpcBridge;
    private final JsonRPCDataBroker rpcDataBroker;
    private final JsonRPCNotificationService notificationService;
    private final ObjectRegistration<DOMMountPoint> mountpointRegistration;
    private final DataBroker dataBroker;
    private final YangInstanceIdentifier biPath;

    public MappedPeerContext(@Nonnull Peer peer, @Nonnull TransportFactory transportFactory, @Nonnull DOMSchemaService schemaService, @Nonnull DataBroker dataBroker, @Nonnull DOMMountPointService mountService, @Nullable RemoteGovernance governance) throws URISyntaxException {
        SchemaContext schema;
        this.peer = Objects.requireNonNull(peer);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        MutablePeer newPeer = new MutablePeer().name(peer.getName());
        if (MappedPeerContext.supportInbandModels(peer)) {
            schema = InbandModelsSchemaContextProvider.create(transportFactory).createSchemaContext(peer);
            newPeer.addModels(schema.getModules().stream().map(m -> new YangIdentifier(m.getName())).collect(Collectors.toList()));
        } else {
            schema = governance != null ? new GovernanceSchemaContextProvider(governance).createSchemaContext(peer) : new BuiltinSchemaContextProvider(schemaService.getGlobalContext()).createSchemaContext(peer);
        }
        this.biPath = Util.createBiPath(peer.getName());
        DOMMountPointService.DOMMountPointBuilder mountBuilder = mountService.createMountPoint(this.biPath);
        this.jsonConverter = new JsonConverter(schema);
        mountBuilder.addInitialSchemaContext(schema);
        this.rpcDataBroker = new JsonRPCDataBroker(peer, schema, this.pathMap, transportFactory, governance, this.jsonConverter);
        mountBuilder.addService(DOMDataBroker.class, (DOMService)this.rpcDataBroker);
        this.pathMap.toMap(DataType.CONFIGURATION_DATA).entrySet().stream().forEach(e -> newPeer.addDataConfigEndpoint(new DataConfigEndpointsBuilder().setPath(((JsonElement)e.getKey()).getAsJsonObject().toString()).setEndpointUri(new Uri((String)e.getValue())).build()));
        this.pathMap.toMap(DataType.OPERATIONAL_DATA).entrySet().stream().forEach(e -> newPeer.addDataOperationalEndpoint(new DataOperationalEndpointsBuilder().setPath(((JsonElement)e.getKey()).getAsJsonObject().toString()).setEndpointUri(new Uri((String)e.getValue())).build()));
        this.rpcBridge = new JsonRPCtoRPCBridge(peer, schema, this.pathMap, governance, transportFactory, this.jsonConverter);
        mountBuilder.addService(DOMRpcService.class, (DOMService)this.rpcBridge);
        this.pathMap.toMap(DataType.RPC).entrySet().stream().forEach(e -> newPeer.addRpcEndpoint(new RpcEndpointsBuilder().setPath(((JsonElement)e.getKey()).getAsJsonObject().toString()).setEndpointUri(new Uri((String)e.getValue())).build()));
        this.notificationService = new JsonRPCNotificationService(peer, schema, this.pathMap, this.jsonConverter, transportFactory, governance);
        this.pathMap.toMap(DataType.NOTIFICATION).entrySet().stream().forEach(e -> newPeer.addNotificationEndpoint(new NotificationEndpointsBuilder().setPath(((JsonElement)e.getKey()).getAsJsonObject().toString()).setEndpointUri(new Uri((String)e.getValue())).build()));
        mountBuilder.addService(DOMNotificationService.class, (DOMService)this.notificationService);
        this.mountpointRegistration = mountBuilder.register();
        ActualEndpoints endpoint = new ActualEndpointsBuilder((Peer)newPeer).build();
        InstanceIdentifier peerOpId = InstanceIdentifier.builder(Config.class).child(ActualEndpoints.class, (Identifier)new ActualEndpointsKey(newPeer.getName())).build();
        WriteTransaction wrTrx = dataBroker.newWriteOnlyTransaction();
        wrTrx.put(LogicalDatastoreType.OPERATIONAL, peerOpId, (DataObject)endpoint);
        this.commitTransaction(wrTrx, peer.getName(), "Publish operational state");
    }

    static boolean supportInbandModels(Peer peer) {
        return peer.getModules() != null && peer.getModules().size() == 1 && ((YangIdentifier)peer.getModules().get(0)).getValue().startsWith("jsonrpc-inband-models");
    }

    @Override
    public void close() throws Exception {
        Stream.of(this.rpcDataBroker, this.rpcBridge, this.notificationService, this.mountpointRegistration).forEach(c -> Util.closeNullableWithExceptionCallback(c, e -> LOG.error("Failed to close provider {}", c, e)));
        this.removeOperationalState();
    }

    private void removeOperationalState() {
        WriteTransaction wrTrx = this.dataBroker.newWriteOnlyTransaction();
        InstanceIdentifier peerOpId = InstanceIdentifier.builder(Config.class).child(ActualEndpoints.class, (Identifier)new ActualEndpointsKey(this.peer.getName())).build();
        wrTrx.delete(LogicalDatastoreType.OPERATIONAL, peerOpId);
        this.commitTransaction(wrTrx, this.getName(), "Unpublish operational state");
    }

    private void commitTransaction(final WriteTransaction transaction, final String device, final String txType) {
        LOG.trace("{}: Committing Transaction {}:{}", new Object[]{device, txType, transaction.getIdentifier()});
        transaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo info) {
                LOG.trace("{}: Transaction({}) SUCCESSFUL", (Object)txType, transaction.getIdentifier());
            }

            public void onFailure(Throwable failure) {
                LOG.error("{}: Transaction({}) FAILED!", new Object[]{txType, transaction.getIdentifier(), failure});
                throw new IllegalStateException(String.format("%s : Transaction(%s) not commited currectly", device, txType), failure);
            }
        }, MoreExecutors.directExecutor());
    }

    public String getName() {
        return this.peer.getName();
    }

    public String toString() {
        return "MappedPeerContext [peer=" + this.peer.getName() + ", path = " + this.biPath + "]";
    }
}

