/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

public class SchemaChangeAwareConverter
implements Supplier<JsonConverter>,
AutoCloseable,
SchemaContextListener {
    private final AtomicReference<JsonConverter> converter = new AtomicReference<Object>(null);
    private ListenerRegistration<SchemaContextListener> registration;

    public SchemaChangeAwareConverter(@Nonnull DOMSchemaService domSchemaService) {
        Objects.requireNonNull(domSchemaService);
        this.registration = domSchemaService.registerSchemaContextListener((SchemaContextListener)this);
        this.refresh(domSchemaService.getGlobalContext());
    }

    private void refresh(SchemaContext schemaContext) {
        this.converter.set(new JsonConverter(schemaContext));
    }

    @Override
    public void close() throws Exception {
        this.registration.close();
    }

    @Override
    public JsonConverter get() {
        return this.converter.get();
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        this.refresh(context);
    }
}

