/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangInstanceIdentifierDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(YangInstanceIdentifierDeserializer.class);

    private YangInstanceIdentifierDeserializer() {
    }

    public static YangInstanceIdentifier toYangInstanceIdentifier(JsonElement path, SchemaContext schemaContext) {
        ParsingContext pc = new ParsingContext(schemaContext);
        return pc.parse(path);
    }

    private static final class ParsingContext {
        private final SchemaContext schemaContext;
        private final YangInstanceIdentifier.InstanceIdentifierBuilder builder = YangInstanceIdentifier.builder();
        private QName nodeNs;
        private QName localNs;

        private ParsingContext(SchemaContext schemaContext) {
            this.schemaContext = schemaContext;
        }

        private static void assertNamespace(QName ns) {
            Preconditions.checkNotNull((Object)ns, (Object)"Missing/unresolvable namespace");
        }

        private void throwJsonPathError(JsonElement ex) {
            throw new IllegalStateException(String.format("Unexpected JsonElement : %s => %s", ex.getClass().getSimpleName(), ex));
        }

        private QName lookupByLocalName(String localName) {
            return Util.findModuleWithLatestRevision(this.schemaContext, localName).map(module -> QName.create((QNameModule)module.getQNameModule(), (String)localName)).orElse(null);
        }

        private YangInstanceIdentifier parse(JsonElement path) {
            Preconditions.checkArgument((boolean)(path instanceof JsonObject), (String)"Root element must be instance of JsonObject, actual type is %s", (Object)path.getClass().getSimpleName());
            this.processObject(path);
            return this.builder.build();
        }

        private void processArray(JsonElement path) {
            LOG.debug("Current node [ARRAY ]: {}", (Object)path);
            JsonArray arr = (JsonArray)path;
            for (JsonElement je : arr) {
                if (je instanceof JsonObject) {
                    this.processObject(je);
                    continue;
                }
                this.throwJsonPathError(je);
            }
        }

        private YangInstanceIdentifier processObject(JsonElement path) {
            LOG.debug("Current node [OBJECT]: {}", (Object)path);
            for (Map.Entry e : path.getAsJsonObject().entrySet()) {
                String currentNode = (String)e.getKey();
                JsonElement el = (JsonElement)e.getValue();
                if (currentNode.indexOf(58) == -1) {
                    this.localNs = QName.create((QName)this.nodeNs, (String)currentNode);
                    ParsingContext.assertNamespace(this.localNs);
                } else {
                    String[] localParts = currentNode.split(":");
                    this.nodeNs = this.lookupByLocalName(localParts[0]);
                    ParsingContext.assertNamespace(this.nodeNs);
                    this.updateNodeNamespace(el, localParts[1]);
                }
                if (el instanceof JsonObject) {
                    this.builder.node(this.localNs);
                    this.processObject((JsonElement)e.getValue());
                    continue;
                }
                if (el instanceof JsonArray) {
                    this.builder.node(this.localNs);
                    this.nodeNs = this.localNs;
                    this.processArray((JsonElement)e.getValue());
                    continue;
                }
                if (el instanceof JsonPrimitive) {
                    this.processLeaf((JsonElement)e.getValue());
                    continue;
                }
                this.throwJsonPathError(el);
            }
            return this.builder.build();
        }

        private void updateNodeNamespace(JsonElement el, String namespace) {
            if (el instanceof JsonArray || el instanceof JsonObject) {
                this.nodeNs = this.localNs = QName.create((QName)this.nodeNs, (String)namespace);
            }
        }

        private void processLeaf(JsonElement path) {
            LOG.debug("Current node [LEAF  ]: {}", (Object)path);
            this.builder.nodeWithKey(this.nodeNs, this.localNs, (Object)path.getAsJsonPrimitive().getAsString());
        }
    }
}

