/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.model;

import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class JsonRpcNotification
implements DOMNotification,
DOMEvent {
    private final ContainerNode content;
    private final SchemaPath schemaPath;
    private final Date eventTime;

    public JsonRpcNotification(ContainerNode content, Date eventTime, SchemaPath schemaPath) {
        this.content = content;
        this.eventTime = (Date)eventTime.clone();
        this.schemaPath = schemaPath;
    }

    @Nonnull
    public SchemaPath getType() {
        return this.schemaPath;
    }

    @Nonnull
    public ContainerNode getBody() {
        return this.content;
    }

    public String toString() {
        return "JsonRpcNotification [eventTime=" + this.eventTime + ", content=" + this.content + ", schemaPath=" + this.schemaPath + "]";
    }

    public Instant getEventInstant() {
        return Instant.ofEpochMilli(this.eventTime.getTime());
    }
}

