/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.model;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataConfigEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataOperationalEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.NotificationEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpoints;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MutablePeer
implements Peer {
    private String name;
    private final List<RpcEndpoints> rpcEndpoints = new ArrayList<RpcEndpoints>();
    private final List<DataOperationalEndpoints> dataOperationalEndpoints = new ArrayList<DataOperationalEndpoints>();
    private final List<DataConfigEndpoints> endpoints = new ArrayList<DataConfigEndpoints>();
    private final List<NotificationEndpoints> notificationEndpoints = new ArrayList<NotificationEndpoints>();
    private final List<YangIdentifier> models = new ArrayList<YangIdentifier>();

    public MutablePeer name(String newName) {
        this.name = newName;
        return this;
    }

    public MutablePeer addRpcEndpoint(RpcEndpoints endpoint) {
        this.rpcEndpoints.add(endpoint);
        return this;
    }

    public MutablePeer addModels(List<YangIdentifier> yangIds) {
        this.models.addAll(yangIds);
        return this;
    }

    public MutablePeer addDataOperationalEndpoint(DataOperationalEndpoints endpoint) {
        this.dataOperationalEndpoints.add(endpoint);
        return this;
    }

    public MutablePeer addDataConfigEndpoint(DataConfigEndpoints endpoint) {
        this.endpoints.add(endpoint);
        return this;
    }

    public MutablePeer addNotificationEndpoint(NotificationEndpoints endpoint) {
        this.notificationEndpoints.add(endpoint);
        return this;
    }

    public Class<? extends DataContainer> getImplementedInterface() {
        return MutablePeer.class;
    }

    public String getName() {
        return this.name;
    }

    public List<YangIdentifier> getModules() {
        return this.models;
    }

    public List<DataConfigEndpoints> getDataConfigEndpoints() {
        return this.endpoints;
    }

    public List<DataOperationalEndpoints> getDataOperationalEndpoints() {
        return this.dataOperationalEndpoints;
    }

    public List<RpcEndpoints> getRpcEndpoints() {
        return this.rpcEndpoints;
    }

    public List<NotificationEndpoints> getNotificationEndpoints() {
        return this.notificationEndpoints;
    }
}

