/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.model;

import com.google.common.base.Preconditions;
import java.net.URISyntaxException;
import org.opendaylight.jsonrpc.bus.messagelib.EndpointBuilders;
import org.opendaylight.jsonrpc.bus.messagelib.NotificationMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberSession;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;

public class NotificationState
implements AutoCloseable {
    private final NotificationDefinition notification;
    private final SubscriberSession client;

    public NotificationState(NotificationDefinition notification, String endpoint, NotificationMessageHandler handler, TransportFactory transportFactory) throws URISyntaxException {
        this.notification = (NotificationDefinition)Preconditions.checkNotNull((Object)notification);
        this.client = ((EndpointBuilders.SubscriberBuilder)transportFactory.endpointBuilder().subscriber().useCache()).create(endpoint, (AutoCloseable)handler);
    }

    public NotificationDefinition notification() {
        return this.notification;
    }

    public SubscriberSession client() {
        return this.client;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

