/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.model;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URISyntaxException;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.messagelib.EndpointBuilders;
import org.opendaylight.jsonrpc.bus.messagelib.NoopReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.ReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;

public class RpcState
implements AutoCloseable {
    private final String name;
    private final RpcDefinition rpc;
    private final RequesterSession client;
    private JsonElement result;
    private JsonObject metadata;
    private JsonRpcErrorObject error;

    public RpcState(String qname, RpcDefinition rpc, String endpoint, TransportFactory transportFactory) throws URISyntaxException {
        this.name = (String)Preconditions.checkNotNull((Object)qname);
        Preconditions.checkNotNull((Object)endpoint);
        this.rpc = (RpcDefinition)Preconditions.checkNotNull((Object)rpc);
        this.client = ((EndpointBuilders.RequesterBuilder)transportFactory.endpointBuilder().requester().useCache()).create(endpoint, (ReplyMessageHandler)NoopReplyMessageHandler.INSTANCE);
    }

    public RpcDefinition rpc() {
        return this.rpc;
    }

    public JsonElement lastMessage() {
        return this.result;
    }

    public JsonObject lastMetadata() {
        if (this.metadata != null) {
            return this.metadata.getAsJsonObject();
        }
        return null;
    }

    public JsonRpcErrorObject lastError() {
        return this.error;
    }

    public JsonElement sendRequest(JsonElement argument, JsonObject metadataParam) {
        JsonRpcReplyMessage reply = this.client.sendRequestAndReadReply(this.name, (Object)argument, metadataParam);
        if (!reply.isError()) {
            try {
                this.result = (JsonElement)reply.getResultAsObject(JsonElement.class);
                this.metadata = reply.getMetadata();
                this.error = null;
            }
            catch (JsonRpcException e) {
                this.result = null;
                this.error = reply.getError();
            }
        } else {
            this.result = null;
            this.error = reply.getError();
        }
        return this.result;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

