/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netconf.mdsal.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.function.Consumer;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitoringToMdsalWriter
implements AutoCloseable,
NetconfMonitoringService.CapabilitiesListener,
NetconfMonitoringService.SessionsListener {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringToMdsalWriter.class);
    private static final InstanceIdentifier<Capabilities> CAPABILITIES_INSTANCE_IDENTIFIER = InstanceIdentifier.create(NetconfState.class).child(Capabilities.class);
    private static final InstanceIdentifier<Schemas> SCHEMAS_INSTANCE_IDENTIFIER = InstanceIdentifier.create(NetconfState.class).child(Schemas.class);
    private static final InstanceIdentifier<Sessions> SESSIONS_INSTANCE_IDENTIFIER = InstanceIdentifier.create(NetconfState.class).child(Sessions.class);
    private final NetconfMonitoringService serverMonitoringDependency;
    private final DataBroker dataBroker;

    public MonitoringToMdsalWriter(NetconfMonitoringService serverMonitoringDependency, DataBroker dataBroker) {
        this.serverMonitoringDependency = serverMonitoringDependency;
        this.dataBroker = dataBroker;
    }

    @Override
    public void close() {
        this.runTransaction(tx -> tx.delete(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(NetconfState.class)));
    }

    public void onSessionStarted(Session session) {
        KeyedInstanceIdentifier sessionPath = SESSIONS_INSTANCE_IDENTIFIER.child(Session.class, (Identifier)session.key());
        this.runTransaction(arg_0 -> MonitoringToMdsalWriter.lambda$onSessionStarted$1((InstanceIdentifier)sessionPath, session, arg_0));
    }

    public void onSessionEnded(Session session) {
        KeyedInstanceIdentifier sessionPath = SESSIONS_INSTANCE_IDENTIFIER.child(Session.class, (Identifier)session.key());
        this.runTransaction(arg_0 -> MonitoringToMdsalWriter.lambda$onSessionEnded$2((InstanceIdentifier)sessionPath, arg_0));
    }

    public void onSessionsUpdated(Collection<Session> sessions) {
        this.runTransaction(tx -> MonitoringToMdsalWriter.updateSessions(tx, sessions));
    }

    public void onCapabilitiesChanged(Capabilities capabilities) {
        this.runTransaction(tx -> tx.put(LogicalDatastoreType.OPERATIONAL, CAPABILITIES_INSTANCE_IDENTIFIER, (DataObject)capabilities));
    }

    public void onSchemasChanged(Schemas schemas) {
        this.runTransaction(tx -> tx.put(LogicalDatastoreType.OPERATIONAL, SCHEMAS_INSTANCE_IDENTIFIER, (DataObject)schemas));
    }

    public void start() {
        this.serverMonitoringDependency.registerCapabilitiesListener((NetconfMonitoringService.CapabilitiesListener)this);
        this.serverMonitoringDependency.registerSessionsListener((NetconfMonitoringService.SessionsListener)this);
    }

    private void runTransaction(Consumer<WriteTransaction> txUser) {
        Preconditions.checkState((this.dataBroker != null ? 1 : 0) != 0);
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        txUser.accept(tx);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Netconf state updated successfully");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to update netconf state", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private static void updateSessions(WriteTransaction tx, Collection<Session> sessions) {
        for (Session session : sessions) {
            KeyedInstanceIdentifier sessionPath = SESSIONS_INSTANCE_IDENTIFIER.child(Session.class, (Identifier)session.key());
            tx.put(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)sessionPath, (DataObject)session);
        }
    }

    private static /* synthetic */ void lambda$onSessionEnded$2(InstanceIdentifier sessionPath, WriteTransaction tx) {
        tx.delete(LogicalDatastoreType.OPERATIONAL, sessionPath);
    }

    private static /* synthetic */ void lambda$onSessionStarted$1(InstanceIdentifier sessionPath, Session session, WriteTransaction tx) {
        tx.put(LogicalDatastoreType.OPERATIONAL, sessionPath, (DataObject)session);
    }
}

